/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.editpolicies;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.StatefulView;
import org.eclipse.papyrus.infra.gmfdiag.css.service.CssMarkerEventManagerService;
import org.eclipse.papyrus.infra.gmfdiag.css.service.MarkerToPseudoSelectorMappingService;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.w3c.dom.Element;

public class MarkerEventListenerEditPolicy
extends AbstractEditPolicy
implements EditPolicy,
EditPartListener {
    public static final String ROLE = "MARKER_EVENT_LISTENER";
    protected CssMarkerEventManagerService markerEventManagerService;
    protected final Map<String, String> markerStringToMarkerPseudoSelector = new HashMap<String, String>();
    protected MarkerToPseudoSelectorMappingService markerToPseudoSelectorMappingService;

    public void activate() {
        try {
            ServicesRegistry servicesRegistry = ServiceUtilsForEditPart.getInstance().getServiceRegistry((EditPart)this.getHost());
            this.markerEventManagerService = (CssMarkerEventManagerService)servicesRegistry.getService(CssMarkerEventManagerService.class);
            if (this.markerEventManagerService != null) {
                this.markerEventManagerService.registerEditPolicy(this);
            }
            this.markerToPseudoSelectorMappingService = (MarkerToPseudoSelectorMappingService)servicesRegistry.getService(MarkerToPseudoSelectorMappingService.class);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        this.getHost().addEditPartListener((EditPartListener)this);
    }

    public void deactivate() {
        if (this.markerEventManagerService != null) {
            this.markerEventManagerService.unregisterEditPolicy(this);
        }
        this.getHost().removeEditPartListener((EditPartListener)this);
        this.markerStringToMarkerPseudoSelector.clear();
    }

    protected View getSemanticView() {
        return (View)this.getHost().getModel();
    }

    public void updateState(Set<String> state, int addedOrRemoved) {
        MarkerEventListenerEditPolicy primaryEditPolicy = this.getPrimaryEditPolicy();
        if (primaryEditPolicy == this) {
            Element domElement;
            View view = this.getSemanticView();
            if (view.getDiagram() instanceof CSSDiagram && (domElement = ((CSSDiagram)view.getDiagram()).getEngine().getElement(view)) instanceof StatefulView) {
                if (addedOrRemoved == 1) {
                    ((StatefulView)((Object)domElement)).addStates(state);
                } else {
                    ((StatefulView)((Object)domElement)).removeStates(state);
                }
            }
        } else if (primaryEditPolicy != null) {
            primaryEditPolicy.updateState(state, addedOrRemoved);
        }
    }

    private MarkerEventListenerEditPolicy getPrimaryEditPolicy() {
        GraphicalEditPart current = this.getHost();
        EditPart parent = current.getParent();
        while (parent != null && this.semanticCompareEditParts(parent, (EditPart)this.getHost())) {
            current = parent;
            parent = parent.getParent();
        }
        return (MarkerEventListenerEditPolicy)current.getEditPolicy((Object)ROLE);
    }

    private boolean semanticCompareEditParts(EditPart one, EditPart other) {
        if (one.getModel() instanceof View && other.getModel() instanceof View) {
            View view1 = (View)one.getModel();
            View view2 = (View)other.getModel();
            return view1 != null && view2 != null && view1.getElement() == view2.getElement();
        }
        return false;
    }

    public GraphicalEditPart getHost() {
        return (GraphicalEditPart)super.getHost();
    }

    public void selectedStateChanged(EditPart editpart) {
    }

    public void childAdded(EditPart child, int index) {
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
    }

    public void notifyMarkerChange(IPapyrusMarker marker, int addedOrRemoved) {
        String cssName = this.getPseudoSelector(marker);
        if (cssName != null && !"".equals(cssName)) {
            HashSet<String> state = new HashSet<String>();
            state.add(cssName);
            this.updateState(state, addedOrRemoved);
        }
    }

    public void notifyMarkerChange(IPapyrusMarker[] markers, int addedOrRemoved) {
        if (markers.length == 0) {
            return;
        }
        String cssName = "";
        HashSet<String> state = new HashSet<String>();
        int i = 0;
        while (i < markers.length) {
            cssName = this.getPseudoSelector(markers[i]);
            if (cssName != null && !cssName.equals("")) {
                state.add(cssName);
            }
            ++i;
        }
        this.updateState(state, addedOrRemoved);
    }

    protected String getPseudoSelector(IPapyrusMarker marker) {
        block4: {
            try {
                if (!marker.exists()) {
                    String pseudoSelector = this.markerStringToMarkerPseudoSelector.get(marker.toString());
                    return pseudoSelector == null ? "" : pseudoSelector;
                }
                if (this.markerToPseudoSelectorMappingService != null) break block4;
                return "";
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
                return "";
            }
        }
        String pseudoSelector = this.markerToPseudoSelectorMappingService.getPseudoSelector(marker.getType());
        this.markerStringToMarkerPseudoSelector.put(marker.toString(), pseudoSelector);
        return pseudoSelector;
    }
}

