/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.util;

import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.layers.stackmodel.util.NotationAndUmlModelsFactory;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NotationAndUmlModelsFactoryTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testNotationAndUmlModelsTestUtils() {
        NotationAndUmlModelsFactory factory = new NotationAndUmlModelsFactory();
        Assert.assertNotNull((String)"object created", (Object)factory);
    }

    @Test
    public void testNewDiagram() {
        NotationAndUmlModelsFactory factory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = factory.newDiagram();
        Assert.assertNotNull((String)"diagram1 created", (Object)diagram1);
    }

    @Test
    public void testNewClass() {
        NotationAndUmlModelsFactory factory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = factory.newDiagram();
        Class c1 = factory.newClass(diagram1, "C1");
        Class c2 = factory.newClass(diagram1, "C2");
        View shape1 = factory.lookupViewFor(diagram1, (NamedElement)c1);
        View shape2 = factory.lookupViewFor(diagram1, (NamedElement)c2);
        Assert.assertNotNull((String)"class created", (Object)c1);
        Assert.assertNotNull((String)"shape created", (Object)shape2);
        Assert.assertNotNull((String)"shape created", (Object)shape1);
    }

    @Test
    public void testRemove() {
        NotationAndUmlModelsFactory factory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = factory.newDiagram();
        Class c1 = factory.newClass(diagram1, "C1");
        Class c2 = factory.newClass(diagram1, "C2");
        View shape1 = factory.lookupViewFor(diagram1, (NamedElement)c1);
        View shape2 = factory.lookupViewFor(diagram1, (NamedElement)c2);
        View removedShape = factory.remove(diagram1, (NamedElement)c1);
        View lookupResult = factory.lookupViewFor(diagram1, (NamedElement)c1);
        Assert.assertNotNull((String)"object removed found", (Object)removedShape);
        Assert.assertSame((String)"Right object removed", (Object)shape1, (Object)removedShape);
        Assert.assertNull((String)"lookupResult null after remove", (Object)lookupResult);
    }

    @Test
    public void testNewProperty() {
        NotationAndUmlModelsFactory factory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = factory.newDiagram();
        Class c1 = factory.newClass(diagram1, "C1");
        Property p1 = factory.newProperty(c1, "p1");
        Assert.assertNotNull((String)"property created", (Object)p1);
    }
}

