/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.operators;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.layers.stackmodel.layers.BooleanInstance;
import org.eclipse.papyrus.layers.stackmodel.layers.ColorInstance;
import org.eclipse.papyrus.layers.stackmodel.layers.FillInstance;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.TypeInstance;
import org.eclipse.papyrus.layers.stackmodel.operators.CustomPropertyOperatorsInstance;

public class FillAverageOperator
implements CustomPropertyOperatorsInstance {
    public static final BooleanInstance FALSE_INSTANCE = LayersFactory.eINSTANCE.createBooleanInstance();
    public static final BooleanInstance TRUE_INSTANCE;

    static {
        FALSE_INSTANCE.setValue(false);
        TRUE_INSTANCE = LayersFactory.eINSTANCE.createBooleanInstance();
        TRUE_INSTANCE.setValue(true);
    }

    @Override
    public ComputePropertyValueCommand getComputePropertyValueCommand(EList<ComputePropertyValueCommand> nestedCommand) throws LayersException {
        return new FillAverageCommand(nestedCommand);
    }

    class FillAverageCommand
    implements ComputePropertyValueCommand {
        EList<ComputePropertyValueCommand> nestedCommand;

        public FillAverageCommand(EList<ComputePropertyValueCommand> nestedCommand) {
            this.nestedCommand = nestedCommand;
        }

        @Override
        public TypeInstance getCmdValue() throws LayersException {
            int fill = 0;
            int color = 0;
            for (ComputePropertyValueCommand curCmd : this.nestedCommand) {
                FillInstance curValue = (FillInstance)curCmd.getCmdValue();
                fill += curValue.getTransparency();
                color += curValue.getFillColor().getValue();
            }
            FillInstance res = LayersFactory.eINSTANCE.createFillInstance();
            ColorInstance colorInstance = LayersFactory.eINSTANCE.createColorInstance();
            res.setFillColor(colorInstance);
            res.setTransparency(fill / this.nestedCommand.size());
            res.getFillColor().setValue(color / this.nestedCommand.size());
            return res;
        }
    }
}

