/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.operators;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.layers.stackmodel.layers.BooleanInstance;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.TypeInstance;
import org.eclipse.papyrus.layers.stackmodel.operators.CustomPropertyOperatorsInstance;

public class BooleanOrOperator
implements CustomPropertyOperatorsInstance {
    public static final BooleanInstance FALSE_INSTANCE = LayersFactory.eINSTANCE.createBooleanInstance();
    public static final BooleanInstance TRUE_INSTANCE;

    static {
        FALSE_INSTANCE.setValue(false);
        TRUE_INSTANCE = LayersFactory.eINSTANCE.createBooleanInstance();
        TRUE_INSTANCE.setValue(true);
    }

    @Override
    public ComputePropertyValueCommand getComputePropertyValueCommand(EList<ComputePropertyValueCommand> nestedCommand) throws LayersException {
        return new BooleanOrOperatorCommand(nestedCommand);
    }

    class BooleanOrOperatorCommand
    implements ComputePropertyValueCommand {
        EList<ComputePropertyValueCommand> nestedCommand;

        public BooleanOrOperatorCommand(EList<ComputePropertyValueCommand> nestedCommand) {
            this.nestedCommand = nestedCommand;
        }

        @Override
        public TypeInstance getCmdValue() throws LayersException {
            for (ComputePropertyValueCommand curCmd : this.nestedCommand) {
                boolean curCmdRes = ((BooleanInstance)curCmd.getCmdValue()).isValue();
                if (!curCmdRes) continue;
                return TRUE_INSTANCE;
            }
            return FALSE_INSTANCE;
        }
    }
}

