/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.util;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.papyrus.layers.stackmodel.Activator;
import org.eclipse.papyrus.layers.stackmodel.BadStateException;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.NotFoundException;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;

public class PropertyIndexedList<T>
extends EObjectResolvingEList<T> {
    private static final long serialVersionUID = 1L;
    protected EMap<String, T> map;
    protected List<Property> propertyList;
    protected Class<?> mapParentClasstype;
    protected final int MAP_FEATURE_ID;
    protected final T NULL_VALUE;

    public PropertyIndexedList(EMap<String, T> map, Class<T> dataClass, InternalEObject layer, int featureID, int mapFeatureID, T nullValue) {
        super(dataClass, layer, featureID);
        this.MAP_FEATURE_ID = mapFeatureID;
        this.NULL_VALUE = nullValue;
        this.mapParentClasstype = layer.getClass();
        this.map = map;
        this.init();
    }

    public PropertyIndexedList(Map<String, T> map, Class<T> dataClass, InternalEObject layer, int featureID, int mapFeatureID, T nullValue) {
        super(dataClass, layer, featureID);
        this.MAP_FEATURE_ID = mapFeatureID;
        this.NULL_VALUE = nullValue;
        this.mapParentClasstype = layer.getClass();
        this.map = (EMap)map;
        this.init();
    }

    protected void init() {
        this.getEObject().eAdapters().add((Object)new PropertyValuesSynchronizer());
    }

    protected boolean isUnique() {
        return false;
    }

    public void setPropertyList(List<Property> propertyList) {
        this.propertyList = propertyList;
        try {
            this.resetListElements();
        }
        catch (BadStateException e) {
            e.printStackTrace();
        }
    }

    private void resetListElements() throws BadStateException {
        int size;
        List<Property> availableProperties;
        this.clear();
        if (this.propertyList == null) {
            return;
        }
        try {
            availableProperties = this.propertyList;
            size = availableProperties.size();
        }
        catch (NullPointerException e) {
            throw new BadStateException("Property 'application.propertyRegistry' must be set for resetAllPropertyValuesFromRegistry() to work.");
        }
        int i = 0;
        while (i < size) {
            String propertyName = availableProperties.get(i).getName();
            Object value = this.map.get((Object)propertyName);
            if (value == null) {
                value = this.NULL_VALUE;
            }
            this.add(value);
            ++i;
        }
    }

    public T get(Property property) throws NotFoundException {
        try {
            return (T)this.get(property.getIndex());
        }
        catch (IndexOutOfBoundsException e) {
            throw new NotFoundException("Can't get element for Property '" + property.getName() + "'. ", e);
        }
    }

    public void set(Property property, T value) throws BadStateException {
        if (this.map == null) {
            throw new BadStateException("Can't set element for Property '" + property.getName() + "'. The associated map should be set first");
        }
        this.map.put((Object)property.getName(), value);
    }

    protected void synchronizePropertyValue(String propertyName, T value) throws BadStateException, NotFoundException {
        if (this.propertyList == null) {
            return;
        }
        try {
            int propertyIndex = this.getPropertyIndex(propertyName);
            this.set(propertyIndex, value);
        }
        catch (NullPointerException e) {
            throw new BadStateException("propertyList should be set first.");
        }
    }

    protected int getPropertyIndex(String propertyName) throws NotFoundException {
        if (propertyName == null) {
            throw new NotFoundException("Null name not Allowed");
        }
        int i = 0;
        while (i < this.propertyList.size()) {
            if (propertyName.equals(this.propertyList.get(i).getName())) {
                return i;
            }
            ++i;
        }
        throw new NotFoundException("No property found under name '" + propertyName + "'");
    }

    public class PropertyValuesSynchronizer
    extends AdapterImpl {
        public void notifyChanged(Notification msg) {
            if (Activator.log.isDebugEnabled()) {
                Activator.log.debug("event " + msg.getEventType());
            }
            if (msg.getFeatureID(PropertyIndexedList.this.mapParentClasstype) == PropertyIndexedList.this.MAP_FEATURE_ID) {
                this.notifyLayerPropertyValueMapChanged(msg);
            }
        }

        protected void notifyLayerPropertyValueMapChanged(Notification msg) {
            if (Activator.log.isDebugEnabled()) {
                Activator.log.debug("map changed " + msg.getEventType());
            }
            switch (msg.getEventType()) {
                case 1: {
                    Object value;
                    Map.Entry entry = (Map.Entry)msg.getNewValue();
                    if (Activator.log.isDebugEnabled()) {
                        Activator.log.debug("SET - newValue=" + entry.getValue() + ", key=" + (String)entry.getKey());
                    }
                    if ((value = entry.getValue()) == null) break;
                    try {
                        PropertyIndexedList.this.synchronizePropertyValue((String)entry.getKey(), value);
                    }
                    catch (BadStateException e) {
                        e.printStackTrace();
                    }
                    catch (NotFoundException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    Map.Entry entry = (Map.Entry)msg.getNewValue();
                    if (Activator.log.isDebugEnabled()) {
                        Activator.log.debug("ADD - newValue=" + entry.getValue() + ", key=" + (String)entry.getKey());
                    }
                    try {
                        PropertyIndexedList.this.synchronizePropertyValue((String)entry.getKey(), entry.getValue());
                    }
                    catch (LayersException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 4: {
                    Map.Entry entry = (Map.Entry)msg.getNewValue();
                    if (Activator.log.isDebugEnabled()) {
                        Activator.log.debug("REMOVE" + entry.getValue() + ", key=" + (String)entry.getKey());
                    }
                    try {
                        PropertyIndexedList.this.synchronizePropertyValue((String)entry.getKey(), PropertyIndexedList.this.NULL_VALUE);
                    }
                    catch (LayersException e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
        }
    }
}

