/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.papyrus.layers.stackmodel.layers.Layer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerExpression;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.stackmodel.layers.TopLayerOperator;

public class LayersFactoryTestUtils {
    protected LayersStackApplication application;
    protected Map<String, LayerExpression> createdLayers = new HashMap<String, LayerExpression>();

    public LayersFactoryTestUtils(LayersStackApplication application) {
        this.application = application;
    }

    public Map<String, LayerExpression> getCreatedLayers() {
        return this.createdLayers;
    }

    public LayerExpression getLayer(String name) {
        return this.createdLayers.get(name);
    }

    public TopLayerOperator newTopLayer() {
        TopLayerOperator layer = LayersFactory.eINSTANCE.createTopLayerOperator();
        layer.setApplication(this.application);
        return layer;
    }

    public TopLayerOperator newTopLayer(String name) {
        TopLayerOperator layer = this.newTopLayer();
        this.createdLayers.put(name, layer);
        return layer;
    }

    public TopLayerOperator newTopLayer(String name, LayerExpression ... exprs) {
        TopLayerOperator layer = this.newTopLayer(exprs);
        this.createdLayers.put(name, layer);
        return layer;
    }

    public TopLayerOperator newTopLayer(LayerExpression ... exprs) {
        TopLayerOperator layer = this.newTopLayer();
        LayerExpression[] layerExpressionArray = exprs;
        int n = exprs.length;
        int n2 = 0;
        while (n2 < n) {
            LayerExpression l = layerExpressionArray[n2];
            layer.getLayers().add((Object)l);
            ++n2;
        }
        return layer;
    }

    public LayerExpression newLayer() {
        Layer layer = LayersFactory.eINSTANCE.createLayer();
        layer.setApplication(this.application);
        return layer;
    }

    public LayerExpression newLayer(String name) {
        LayerExpression layer = this.newLayer();
        this.createdLayers.put(name, layer);
        return layer;
    }
}

