/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.loaders;

import org.eclipse.papyrus.layers.configmodel.layersconfig.Folder;
import org.eclipse.papyrus.layers.configmodel.layersconfig.LayerOperatorConfig;
import org.eclipse.papyrus.layers.configmodel.layersconfig.LayerOperatorMultipleBinding;
import org.eclipse.papyrus.layers.configmodel.layersconfig.OperatorConfig;
import org.eclipse.papyrus.layers.configmodel.layersconfig.PropertyId;
import org.eclipse.papyrus.layers.configmodel.layersconfig.TypeConfig;
import org.eclipse.papyrus.layers.stackmodel.NotFoundException;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperatorDescriptorRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersPackage;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertyRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.loaders.LayersConfigModel;
import org.eclipse.papyrus.layers.stackmodel.layers.loaders.LayersConfigModelUtils;
import org.eclipse.papyrus.layers.stackmodel.layers.loaders.RegistriesLoader;
import org.eclipse.papyrus.layers.stackmodel.operators.BooleanAndOperator;
import org.eclipse.papyrus.layers.stackmodel.operators.BooleanOrOperator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RegistriesLoaderTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testRegistriesLoader() {
        LayersConfigModel model = new LayersConfigModel();
        this.initLayersConfigModel(model);
        RegistriesLoader loader = new RegistriesLoader(model);
        Assert.assertNotNull((String)"loader created", (Object)loader);
    }

    @Test
    public void testLoadLayerOperator() {
        LayersConfigModel model = new LayersConfigModel();
        this.initLayersConfigModel(model);
        RegistriesLoader loader = new RegistriesLoader(model);
        PropertyRegistry propertyRegistry = LayersFactory.eINSTANCE.createPropertyRegistry();
        LayerOperatorDescriptorRegistry registry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        registry.setPropertyCollectionSize(propertyRegistry.getPropertiesCount());
        loader.loadLayerOperatorDescriptorRegistry(registry, propertyRegistry);
        Assert.assertTrue((String)"descriptors created", (registry.getDescriptors().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"operators created", (registry.getPropertyOperators().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadLayerOperatorDescriptorRegistry() throws NotFoundException {
        LayersConfigModel model = new LayersConfigModel();
        this.initLayersConfigModel(model);
        RegistriesLoader loader = new RegistriesLoader(model);
        PropertyRegistry propertyRegistry = LayersFactory.eINSTANCE.createPropertyRegistry();
        LayerOperatorDescriptorRegistry registry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        registry.setPropertyCollectionSize(propertyRegistry.getPropertiesCount());
        loader.loadLayerOperatorDescriptorRegistry(registry, propertyRegistry);
        Assert.assertTrue((String)"descriptors created", (registry.getDescriptors().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"operators created", (registry.getPropertyOperators().size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"descriptor found", (Object)registry.getLayerOperatorDescriptor("StackedLayersOperatorA"));
        Assert.assertTrue((String)"operators set", (registry.getLayerOperatorDescriptor("StackedLayersOperatorA").getPropertyOperators().size() > 0 ? 1 : 0) != 0);
        Property property = propertyRegistry.getProperty("isVisible");
        Assert.assertNotNull((String)"operator found", (Object)registry.getLayerOperatorDescriptor("StackedLayersOperatorA").getPropertyOperator(property));
    }

    @Test
    public void testLoadLayerOperatorOnly() throws NotFoundException {
        LayersConfigModel model = new LayersConfigModel();
        this.initModelWithLayerOperatorOnly(model);
        RegistriesLoader loader = new RegistriesLoader(model);
        PropertyRegistry propertyRegistry = LayersFactory.eINSTANCE.createPropertyRegistry();
        LayerOperatorDescriptorRegistry registry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        registry.setPropertyCollectionSize(propertyRegistry.getPropertiesCount());
        loader.loadLayerOperatorDescriptorRegistry(registry, propertyRegistry);
        Assert.assertTrue((String)"descriptors created", (registry.getDescriptors().size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"descriptor found", (Object)registry.getLayerOperatorDescriptor("StackedLayersOperatorA"));
    }

    private void initModelWithLayerOperatorOnly(LayersConfigModel model) {
        Folder layeropFolder = LayersConfigModelUtils.createFolder(model.getRootFolder(), "layerOpDesc");
        LayerOperatorConfig layerOpA = LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "StackedLayersOperatorA", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
        LayerOperatorConfig layerOpB = LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "StackedLayersOperatorB", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
        LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "StackedLayersOperatorC", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
        LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "StackedLayersOperatorD", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
    }

    private void initLayersConfigModel(LayersConfigModel model) {
        Folder layeropFolder = LayersConfigModelUtils.createFolder(model.getRootFolder(), "layerOpDesc");
        LayerOperatorConfig layerOpA = LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "StackedLayersOperatorA", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
        LayerOperatorConfig layerOpB = LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "StackedLayersOperatorB", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
        LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "StackedLayersOperatorC", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
        LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "StackedLayersOperatorD", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
        Folder operatorFolder = LayersConfigModelUtils.createFolder(model.getRootFolder(), "operatorDesc");
        OperatorConfig operatorBooleanAnd = LayersConfigModelUtils.createPropertyOperatorConfig(operatorFolder, "operatorBooleanAnd", BooleanAndOperator.class.getName());
        OperatorConfig operatorBooleanOr = LayersConfigModelUtils.createPropertyOperatorConfig(operatorFolder, "operatorBooleanOr", BooleanOrOperator.class.getName());
        Folder typeFolder = LayersConfigModelUtils.createFolder(model.getRootFolder(), "types");
        TypeConfig typeBoolean = LayersConfigModelUtils.createTypeConfig(typeFolder, "boolean");
        TypeConfig typeInt = LayersConfigModelUtils.createTypeConfig(typeFolder, "int");
        TypeConfig typeString = LayersConfigModelUtils.createTypeConfig(typeFolder, "String");
        TypeConfig typeFont = LayersConfigModelUtils.createTypeConfig(typeFolder, "Font");
        TypeConfig typeColor = LayersConfigModelUtils.createTypeConfig(typeFolder, "Color");
        TypeConfig typeFill = LayersConfigModelUtils.createTypeConfig(typeFolder, "Fill");
        TypeConfig typeLine = LayersConfigModelUtils.createTypeConfig(typeFolder, "Line");
        Folder propertiesFolder = LayersConfigModelUtils.createFolder(model.getRootFolder(), "properties");
        PropertyId propertyIsVisible = LayersConfigModelUtils.createPropertyId(propertiesFolder, "isVisible", typeBoolean);
        PropertyId propertyIsAbstract = LayersConfigModelUtils.createPropertyId(propertiesFolder, "isAbstract", typeBoolean);
        PropertyId propertyFill = LayersConfigModelUtils.createPropertyId(propertiesFolder, "fill", typeFill);
        PropertyId propertyLine = LayersConfigModelUtils.createPropertyId(propertiesFolder, "line", typeLine);
        PropertyId propertyFont = LayersConfigModelUtils.createPropertyId(propertiesFolder, "font", typeFont);
        PropertyId propertyBgcolor = LayersConfigModelUtils.createPropertyId(propertiesFolder, "bgcolor", typeColor);
        PropertyId propertyFgcolor = LayersConfigModelUtils.createPropertyId(propertiesFolder, "fgcolor", typeColor);
        Folder opBindingFolder = LayersConfigModelUtils.createFolder(model.getRootFolder(), "opBindings");
        LayerOperatorMultipleBinding layerOpBindingsA = LayersConfigModelUtils.createLayerOperatorsMultipleBinding(opBindingFolder, layerOpA);
        LayersConfigModelUtils.createOperatorBinding(layerOpBindingsA, propertyIsVisible, operatorBooleanAnd);
        LayersConfigModelUtils.createOperatorBinding(layerOpBindingsA, propertyIsAbstract, operatorBooleanAnd);
        LayerOperatorMultipleBinding layerOpBindingsB = LayersConfigModelUtils.createLayerOperatorsMultipleBinding(opBindingFolder, layerOpB);
        LayersConfigModelUtils.createOperatorBinding(layerOpBindingsB, propertyIsVisible, operatorBooleanOr);
        LayersConfigModelUtils.createOperatorBinding(layerOpBindingsB, propertyIsAbstract, operatorBooleanOr);
    }
}

