/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.layers.stackmodel.layers.Layer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertyRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.TopLayerOperator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TopLayerOperatorImplGetComputeCommandTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    protected Layer createLayer(LayerOperator parent, List<View> views, List<Property> properties) throws LayersException {
        Layer layer = LayersFactory.eINSTANCE.createLayer();
        layer.setApplication(parent.getApplication());
        parent.getLayers().add((Object)layer);
        for (View view : views) {
            layer.getViews().add((Object)view);
        }
        for (Property property : properties) {
            layer.addPropertyInstance(property);
        }
        return layer;
    }

    @Test
    public void testCreateLayer() throws LayersException {
        TopLayerOperator layerParent = LayersFactory.eINSTANCE.createTopLayerOperator();
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        layerParent.setApplication(application);
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        Shape view3 = NotationFactory.eINSTANCE.createShape();
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Property property2 = (Property)propertyRegistry.getProperties().get(index++);
        Property property3 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer = this.createLayer(layerParent, Arrays.asList(view1, view2), Arrays.asList(property1, property2));
        Assert.assertNotNull((String)"layer created", (Object)layer);
        Assert.assertSame((String)"views added", (Object)2, (Object)layer.getViews().size());
        Assert.assertSame((String)"property instance added", (Object)2, (Object)layer.getPropertyValueMap().values().size());
        Assert.assertSame((String)"property instance is correctly set", (Object)layer.getPropertyValueMap().get((Object)property1.getName()), (Object)layer.getPropertyInstance(property1));
        Assert.assertSame((String)"property instance is correctly set", (Object)layer.getPropertyValueMap().get((Object)property2.getName()), (Object)layer.getPropertyInstance(property2));
    }

    @Test
    public void testGetComputePropertyValueCommand() throws LayersException {
        TopLayerOperator layer = LayersFactory.eINSTANCE.createTopLayerOperator();
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        layer.setApplication(application);
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        Shape view3 = NotationFactory.eINSTANCE.createShape();
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Property property2 = (Property)propertyRegistry.getProperties().get(index++);
        Property property3 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer1 = this.createLayer(layer, Arrays.asList(view1), Arrays.asList(property1));
        Layer layer2 = this.createLayer(layer, Arrays.asList(view2), Arrays.asList(property1, property2));
        Layer layer3 = this.createLayer(layer, Arrays.asList(view3), Arrays.asList(property2, property3));
        ComputePropertyValueCommand cmd = layer.getComputePropertyValueCommand((View)view1, property1);
        Assert.assertNotNull((String)"cmd created", (Object)cmd);
        Assert.assertSame((String)"cmd s the property instance", (Object)layer1.getPropertyInstance(property1), (Object)cmd);
        cmd = layer.getComputePropertyValueCommand((View)view2, property1);
        Assert.assertNotNull((String)"cmd created", (Object)cmd);
        Assert.assertSame((String)"cmd s the property instance", (Object)layer2.getPropertyInstance(property1), (Object)cmd);
        cmd = layer.getComputePropertyValueCommand((View)view3, property1);
        Assert.assertNull((String)"cmd is null", (Object)cmd);
    }

    @Test
    public void testGetViewsComputePropertyValueCommandListOfViewProperty() throws LayersException {
        TopLayerOperator layer = LayersFactory.eINSTANCE.createTopLayerOperator();
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        layer.setApplication(application);
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        Shape view3 = NotationFactory.eINSTANCE.createShape();
        Shape view4 = NotationFactory.eINSTANCE.createShape();
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Property property2 = (Property)propertyRegistry.getProperties().get(index++);
        Property property3 = (Property)propertyRegistry.getProperties().get(index++);
        Property property4 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer1 = this.createLayer(layer, Arrays.asList(view1), Arrays.asList(property1));
        Layer layer2 = this.createLayer(layer, Arrays.asList(view2), Arrays.asList(property1, property2));
        Layer layer3 = this.createLayer(layer, Arrays.asList(view3), Arrays.asList(property2, property3));
        EList<ComputePropertyValueCommand> cmds = layer.getViewsComputePropertyValueCommand(Arrays.asList(view1, view2), property1);
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)2, (Object)cmds.size());
        int i = 0;
        Assert.assertSame((String)"cmd is the property instance", (Object)layer1.getPropertyInstance(property1), cmds.get(i++));
        Assert.assertSame((String)"cmd is the property instance", (Object)layer2.getPropertyInstance(property1), cmds.get(i++));
        cmds = layer.getViewsComputePropertyValueCommand(Arrays.asList(view1, view2), property2);
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)2, (Object)cmds.size());
        i = 0;
        Assert.assertSame((String)"cmd is the property instance", null, cmds.get(i++));
        Assert.assertSame((String)"cmd is the property instance", (Object)layer2.getPropertyInstance(property2), cmds.get(i++));
        cmds = layer.getViewsComputePropertyValueCommand(Arrays.asList(view4), property3);
        Assert.assertNull((String)"cmd created", cmds);
        cmds = layer.getViewsComputePropertyValueCommand(Arrays.asList(view1, view2), property4);
        Assert.assertNull((String)"cmd created", cmds);
        cmds = layer.getViewsComputePropertyValueCommand(Arrays.asList(view1, null, view3), property1);
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)3, (Object)cmds.size());
        i = 0;
        Assert.assertSame((String)"cmd is the property instance", (Object)layer1.getPropertyInstance(property1), cmds.get(i++));
        Assert.assertSame((String)"cmd is null", null, cmds.get(i++));
        Assert.assertSame((String)"cmd is the property instance", null, cmds.get(i++));
    }

    @Test
    public void testGetPropertiesComputePropertyValueCommandViewListOfProperty() throws LayersException {
        TopLayerOperator layer = LayersFactory.eINSTANCE.createTopLayerOperator();
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        layer.setApplication(application);
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        Shape view3 = NotationFactory.eINSTANCE.createShape();
        Shape view4 = NotationFactory.eINSTANCE.createShape();
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Property property2 = (Property)propertyRegistry.getProperties().get(index++);
        Property property3 = (Property)propertyRegistry.getProperties().get(index++);
        Property property4 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer1 = this.createLayer(layer, Arrays.asList(view1), Arrays.asList(property1));
        Layer layer2 = this.createLayer(layer, Arrays.asList(view1, view2), Arrays.asList(property1, property2));
        Layer layer3 = this.createLayer(layer, Arrays.asList(view3), Arrays.asList(property3));
        EList<ComputePropertyValueCommand> cmds = layer.getPropertiesComputePropertyValueCommand((View)view1, Arrays.asList(property1, property2));
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)2, (Object)cmds.size());
        int i = 0;
        Assert.assertSame((String)"cmd is the property instance", (Object)layer1.getPropertyInstance(property1), cmds.get(i++));
        Assert.assertSame((String)"cmd is the property instance", (Object)layer2.getPropertyInstance(property2), cmds.get(i++));
        cmds = layer.getPropertiesComputePropertyValueCommand((View)view2, Arrays.asList(property1, property4));
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)2, (Object)cmds.size());
        i = 0;
        Assert.assertSame((String)"cmd is the property instance", (Object)layer2.getPropertyInstance(property1), cmds.get(i++));
        Assert.assertSame((String)"cmd is the property instance", null, cmds.get(i++));
        cmds = layer.getPropertiesComputePropertyValueCommand((View)view4, Arrays.asList(property3));
        Assert.assertNull((String)"cmd created", cmds);
        cmds = layer.getPropertiesComputePropertyValueCommand((View)view3, Arrays.asList(property1, property2));
        Assert.assertNull((String)"cmd created", cmds);
        cmds = layer.getPropertiesComputePropertyValueCommand((View)view1, Arrays.asList(property1, null, property2));
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)3, (Object)cmds.size());
        i = 0;
        Assert.assertSame((String)"cmd is the property instance", (Object)layer1.getPropertyInstance(property1), cmds.get(i++));
        Assert.assertSame((String)"cmd is null", null, cmds.get(i++));
        Assert.assertSame((String)"cmd is the property instance", (Object)layer2.getPropertyInstance(property2), cmds.get(i++));
    }

    @Test
    public void testTopLayerOperatorImpl() {
        TopLayerOperator layer = LayersFactory.eINSTANCE.createTopLayerOperator();
        Assert.assertNotNull((String)"object created", (Object)layer);
    }
}

