/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.ocl.conditions.BooleanOCLCondition;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.IQueryResult;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.RegExpLayer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RegExpLayerImplWithQueriesTest {
    protected final String PLUGIN_PROJECT_NAME = "org.eclipse.papyrus.layers.stackmodel";

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testRegExpLayerImpl() {
        RegExpLayer layer = LayersFactory.eINSTANCE.createRegExpLayer();
        Assert.assertNotNull((String)"object created", (Object)layer);
    }

    @Test
    public void testSetExpr() {
        RegExpLayer layer = LayersFactory.eINSTANCE.createRegExpLayer();
        Assert.assertNotNull((String)"object created", (Object)layer);
        layer.setExpr("An expression");
    }

    @Test
    public void testEvaluateExpr() throws ParserException {
        RegExpLayer layer = LayersFactory.eINSTANCE.createRegExpLayer();
        Assert.assertNotNull((String)"object created", (Object)layer);
        layer.setExpr("An expression");
        String modelNotationKey = "notation";
        String modelUMLKey = "uml";
        String modelFileName = "/test/models/model1";
        Resource resource = this.getResource(modelFileName, modelNotationKey);
        OCL ocl = OCL.newInstance();
        BooleanOCLCondition condition = new BooleanOCLCondition(ocl.getEnvironment(), "self.oclAsType(Shape).visible = true", (Object)NotationPackage.Literals.SHAPE);
        SELECT statement = new SELECT(0, false, new FROM((Collection)resource.getContents()), new WHERE((EObjectCondition)condition), (IProgressMonitor)new NullProgressMonitor());
        IQueryResult results = statement.execute();
        Assert.assertNotNull((String)"got result", (Object)results);
        Assert.assertFalse((String)"results is not empty", (boolean)results.isEmpty());
    }

    @Test
    public void testResourceExist() throws IOException, CoreException {
        String modelNotationKey = "notation";
        String modelUMLKey = "uml";
        String modelFileName = "/test/models/model1";
        Resource resource = this.getResource(modelFileName, modelNotationKey);
        Assert.assertNotNull((String)"modelFile exist", (Object)resource);
        Assert.assertTrue((String)"model is loaded", (!resource.getContents().isEmpty() ? 1 : 0) != 0);
    }

    private Resource getResource(String modelFileName, String modelNotationKey) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createPlatformPluginURI((String)("org.eclipse.papyrus.layers.stackmodel" + modelFileName + "." + modelNotationKey), (boolean)true);
        System.out.println("URI=" + uri.toString());
        Resource resource = resourceSet.getResource(uri, true);
        return resource;
    }
}

