/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import com.google.common.eventbus.Subscribe;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.IQueryResult;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.papyrus.layers.stackmodel.Activator;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.NotFoundException;
import org.eclipse.papyrus.layers.stackmodel.exprmatcher.ExpressionMatcher;
import org.eclipse.papyrus.layers.stackmodel.layers.AbstractLayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.EventLevel;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersPackage;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStack;
import org.eclipse.papyrus.layers.stackmodel.layers.RegExpLayer;
import org.eclipse.papyrus.layers.stackmodel.layers.impl.AbstractLayerImpl;
import org.eclipse.papyrus.layers.stackmodel.notifier.DiagramViewEventNotifier;
import org.eclipse.papyrus.layers.stackmodel.notifier.IDiagramViewEventListener;
import org.eclipse.papyrus.layers.stackmodel.util.ObservableListView;

public class RegExpLayerImpl
extends AbstractLayerImpl
implements RegExpLayer {
    protected static final String EXPR_EDEFAULT = null;
    protected String expr = EXPR_EDEFAULT;
    protected static final String LANGUAGE_EDEFAULT = null;
    protected String language = LANGUAGE_EDEFAULT;
    protected static final boolean IS_DOMAIN_CHANGED_EVENT_DEPENDANT_EDEFAULT = false;
    protected boolean isDomainChangedEventDependant = false;
    protected static final EventLevel DOMAIN_CHANGED_EVENT_LEVEL_EDEFAULT = EventLevel.LEVEL1;
    protected EventLevel domainChangedEventLevel = DOMAIN_CHANGED_EVENT_LEVEL_EDEFAULT;
    protected static final boolean IS_DIAGRAM_CHANGED_EVENT_DEPENDANT_EDEFAULT = false;
    protected boolean isDiagramChangedEventDependant = false;
    protected static final EventLevel DIAGRAM_CHANGED_EVENT_LEVEL_EDEFAULT = EventLevel.LEVEL1;
    protected EventLevel diagramChangedEventLevel = DIAGRAM_CHANGED_EVENT_LEVEL_EDEFAULT;
    protected static final String EXPRESSION_CONTEXT_OBJECT_TYPE_EDEFAULT = null;
    protected String expressionContextObjectType = EXPRESSION_CONTEXT_OBJECT_TYPE_EDEFAULT;
    protected DiagramViewEventNotifier diagramViewEventNotifier;
    protected ExpressionMatcher expressionMatcher = new ExpressionMatcher((List<View>)this.getViews());
    protected EObjectCondition condition;
    protected OCL ocl;

    protected RegExpLayerImpl() {
        this.resetExpressionMatcherRoots();
    }

    @Override
    protected void startBehaviors() {
        super.startBehaviors();
    }

    @Override
    public void startAfterReloading() {
        super.startAfterReloading();
    }

    @Override
    public void attachToLayersStack(LayersStack owningLayersStack) {
        super.attachToLayersStack(owningLayersStack);
    }

    @Override
    protected EClass eStaticClass() {
        return LayersPackage.Literals.REG_EXP_LAYER;
    }

    @Override
    public String getExpr() {
        return this.expr;
    }

    @Override
    public void setExpr(String newExpr) {
        String oldExpr = this.expr;
        this.expr = newExpr;
        try {
            this.checkViewsAndMatchingElementsSync();
            this.resetExpressionMatcherRoots();
            this.expressionMatcher.setExpression(newExpr);
            this.expressionMatcher.refreshMatchingElements();
        }
        catch (LayersException e) {
            Activator.log.error("Error - " + this.getClass().getSimpleName() + " - " + e.getMessage(), (Throwable)e);
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldExpr, (Object)this.expr));
        }
    }

    private void checkViewsAndMatchingElementsSync() {
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String newLanguage) {
        String oldLanguage = this.language;
        this.language = newLanguage;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldLanguage, (Object)this.language));
        }
    }

    @Override
    public boolean isDomainChangedEventDependant() {
        return this.isDomainChangedEventDependant;
    }

    @Override
    public void setIsDomainChangedEventDependant(boolean newIsDomainChangedEventDependant) {
        boolean oldIsDomainChangedEventDependant = this.isDomainChangedEventDependant;
        this.isDomainChangedEventDependant = newIsDomainChangedEventDependant;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, oldIsDomainChangedEventDependant, this.isDomainChangedEventDependant));
        }
    }

    @Override
    public EventLevel getDomainChangedEventLevel() {
        return this.domainChangedEventLevel;
    }

    @Override
    public void setDomainChangedEventLevel(EventLevel newDomainChangedEventLevel) {
        EventLevel oldDomainChangedEventLevel = this.domainChangedEventLevel;
        EventLevel eventLevel = this.domainChangedEventLevel = newDomainChangedEventLevel == null ? DOMAIN_CHANGED_EVENT_LEVEL_EDEFAULT : newDomainChangedEventLevel;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldDomainChangedEventLevel, (Object)this.domainChangedEventLevel));
        }
    }

    @Override
    public boolean isDiagramChangedEventDependant() {
        return this.isDiagramChangedEventDependant;
    }

    @Override
    public void setIsDiagramChangedEventDependant(boolean newIsDiagramChangedEventDependant) {
        boolean oldIsDiagramChangedEventDependant = this.isDiagramChangedEventDependant;
        this.isDiagramChangedEventDependant = newIsDiagramChangedEventDependant;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, oldIsDiagramChangedEventDependant, this.isDiagramChangedEventDependant));
        }
    }

    @Override
    public EventLevel getDiagramChangedEventLevel() {
        return this.diagramChangedEventLevel;
    }

    @Override
    public void setDiagramChangedEventLevel(EventLevel newDiagramChangedEventLevel) {
        EventLevel oldDiagramChangedEventLevel = this.diagramChangedEventLevel;
        EventLevel eventLevel = this.diagramChangedEventLevel = newDiagramChangedEventLevel == null ? DIAGRAM_CHANGED_EVENT_LEVEL_EDEFAULT : newDiagramChangedEventLevel;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, (Object)oldDiagramChangedEventLevel, (Object)this.diagramChangedEventLevel));
        }
    }

    @Override
    public String getExpressionContextObjectType() {
        return this.expressionContextObjectType;
    }

    @Override
    public void setExpressionContextObjectType(String newExpressionContextObjectType) {
        String oldExpressionContextObjectType = this.expressionContextObjectType;
        this.expressionContextObjectType = newExpressionContextObjectType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, (Object)oldExpressionContextObjectType, (Object)this.expressionContextObjectType));
        }
    }

    @Subscribe
    public void expressionResultChanged(ObservableListView.ObservableListEvent event) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + ".expressionResultChanged()");
        }
        if (!event.getAddedElements().isEmpty()) {
            this.getViews().addAll(event.getAddedElements());
        }
        if (!event.getRemovedElements().isEmpty()) {
            this.getViews().removeAll(event.getRemovedElements());
        }
    }

    @Override
    public void initLayer(LayersStack owningLayersStack) {
        super.initLayer(owningLayersStack);
        this.resetExpressionMatcherRoots();
        this.checkViewsAndMatchingElementsSync();
    }

    private void resetExpressionMatcherRoots() {
        try {
            this.expressionMatcher.setSearchRoots((EObject)this.getLayersStack().getDiagram());
        }
        catch (NotFoundException e) {
            this.expressionMatcher.setSearchRoots(Collections.EMPTY_LIST);
        }
    }

    @Override
    public void activate(AbstractLayerOperator newLayerParent) {
    }

    @Override
    public void deactivate(AbstractLayerOperator oldParentLayer) {
    }

    @Override
    public boolean isDerivedView(View view) throws LayersException {
        if (this.condition == null) {
            return false;
        }
        SELECT statement = new SELECT(0, false, new FROM((EObject)view), new WHERE(this.condition), (IProgressMonitor)new NullProgressMonitor());
        IQueryResult results = statement.execute();
        return !results.isEmpty();
    }

    @Override
    public void attachDerivedView(View view) throws LayersException {
        if (this.condition == null) {
            return;
        }
        SELECT statement = new SELECT(0, false, new FROM((EObject)view), new WHERE(this.condition), (IProgressMonitor)new NullProgressMonitor());
        IQueryResult results = statement.execute();
        if (!results.isEmpty()) {
            EList<View> attachedViews = this.getViews();
            if (attachedViews.contains(view)) {
                return;
            }
            attachedViews.add(view);
        } else {
            this.getViews().remove((Object)view);
        }
    }

    @Override
    public void attachDerivedViews(EList<View> views) throws LayersException {
        if (this.condition == null) {
            return;
        }
        SELECT statement = new SELECT(0, false, new FROM(views), new WHERE(this.condition), (IProgressMonitor)new NullProgressMonitor());
        IQueryResult results = statement.execute();
        ArrayList<View> viewsToAdd = new ArrayList<View>();
        EList<View> attachedViews = this.getViews();
        for (Object o : results) {
            View v = (View)o;
            if (attachedViews.contains(v)) continue;
            viewsToAdd.add(v);
        }
        ArrayList<View> viewsToRemove = new ArrayList<View>();
        for (View v : views.size() < this.getViews().size() ? views : this.getViews()) {
            if (results.contains((Object)v)) continue;
            viewsToRemove.add(v);
        }
        this.getViews().removeAll(viewsToRemove);
        this.getViews().addAll(viewsToAdd);
    }

    @Override
    public void attachDerivedViews() throws LayersException {
        if (this.condition == null) {
            return;
        }
        EList diagramViews = this.getLayersStack().getDiagram().getChildren();
        SELECT statement = new SELECT(0, false, new FROM((Collection)diagramViews), new WHERE(this.condition), (IProgressMonitor)new NullProgressMonitor());
        IQueryResult results = statement.execute();
        ArrayList<View> viewsToAdd = new ArrayList<View>();
        EList<View> attachedViews = this.getViews();
        for (Object o : results) {
            View v = (View)o;
            if (attachedViews.contains(v)) continue;
            viewsToAdd.add(v);
        }
        this.getViews().retainAll((Collection)results);
        this.getViews().addAll(viewsToAdd);
    }

    @Override
    public EList<View> lookupDerivedViews(EList<View> views) throws LayersException {
        return null;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 13: {
                return this.getExpr();
            }
            case 14: {
                return this.getLanguage();
            }
            case 15: {
                return this.isDomainChangedEventDependant();
            }
            case 16: {
                return this.getDomainChangedEventLevel();
            }
            case 17: {
                return this.isDiagramChangedEventDependant();
            }
            case 18: {
                return this.getDiagramChangedEventLevel();
            }
            case 19: {
                return this.getExpressionContextObjectType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 13: {
                this.setExpr((String)newValue);
                return;
            }
            case 14: {
                this.setLanguage((String)newValue);
                return;
            }
            case 15: {
                this.setIsDomainChangedEventDependant((Boolean)newValue);
                return;
            }
            case 16: {
                this.setDomainChangedEventLevel((EventLevel)((Object)newValue));
                return;
            }
            case 17: {
                this.setIsDiagramChangedEventDependant((Boolean)newValue);
                return;
            }
            case 18: {
                this.setDiagramChangedEventLevel((EventLevel)((Object)newValue));
                return;
            }
            case 19: {
                this.setExpressionContextObjectType((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 13: {
                this.setExpr(EXPR_EDEFAULT);
                return;
            }
            case 14: {
                this.setLanguage(LANGUAGE_EDEFAULT);
                return;
            }
            case 15: {
                this.setIsDomainChangedEventDependant(false);
                return;
            }
            case 16: {
                this.setDomainChangedEventLevel(DOMAIN_CHANGED_EVENT_LEVEL_EDEFAULT);
                return;
            }
            case 17: {
                this.setIsDiagramChangedEventDependant(false);
                return;
            }
            case 18: {
                this.setDiagramChangedEventLevel(DIAGRAM_CHANGED_EVENT_LEVEL_EDEFAULT);
                return;
            }
            case 19: {
                this.setExpressionContextObjectType(EXPRESSION_CONTEXT_OBJECT_TYPE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 13: {
                return EXPR_EDEFAULT == null ? this.expr != null : !EXPR_EDEFAULT.equals(this.expr);
            }
            case 14: {
                return LANGUAGE_EDEFAULT == null ? this.language != null : !LANGUAGE_EDEFAULT.equals(this.language);
            }
            case 15: {
                return this.isDomainChangedEventDependant;
            }
            case 16: {
                return this.domainChangedEventLevel != DOMAIN_CHANGED_EVENT_LEVEL_EDEFAULT;
            }
            case 17: {
                return this.isDiagramChangedEventDependant;
            }
            case 18: {
                return this.diagramChangedEventLevel != DIAGRAM_CHANGED_EVENT_LEVEL_EDEFAULT;
            }
            case 19: {
                return EXPRESSION_CONTEXT_OBJECT_TYPE_EDEFAULT == null ? this.expressionContextObjectType != null : !EXPRESSION_CONTEXT_OBJECT_TYPE_EDEFAULT.equals(this.expressionContextObjectType);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 13: {
                this.activate((AbstractLayerOperator)arguments.get(0));
                return null;
            }
            case 14: {
                this.deactivate((AbstractLayerOperator)arguments.get(0));
                return null;
            }
            case 15: {
                try {
                    return this.isDerivedView((View)arguments.get(0));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 16: {
                try {
                    this.attachDerivedView((View)arguments.get(0));
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 17: {
                try {
                    this.attachDerivedViews((EList<View>)((EList)arguments.get(0)));
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 18: {
                try {
                    this.attachDerivedViews();
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 19: {
                try {
                    return this.lookupDerivedViews((EList<View>)((EList)arguments.get(0)));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (expr: ");
        result.append(this.expr);
        result.append(", language: ");
        result.append(this.language);
        result.append(", isDomainChangedEventDependant: ");
        result.append(this.isDomainChangedEventDependant);
        result.append(", domainChangedEventLevel: ");
        result.append((Object)this.domainChangedEventLevel);
        result.append(", isDiagramChangedEventDependant: ");
        result.append(this.isDiagramChangedEventDependant);
        result.append(", diagramChangedEventLevel: ");
        result.append((Object)this.diagramChangedEventLevel);
        result.append(", expressionContextObjectType: ");
        result.append(this.expressionContextObjectType);
        result.append(')');
        return result.toString();
    }

    protected void viewAdded(View view) {
    }

    protected void viewRemoved(View view) {
    }

    public class DiagramViewEventListener
    implements IDiagramViewEventListener {
        @Override
        public void diagramViewAdded(Notification msg) {
            RegExpLayerImpl.this.viewAdded((View)msg.getNewValue());
        }

        @Override
        public void diagramViewRemoved(Notification msg) {
            RegExpLayerImpl.this.viewRemoved((View)msg.getNewValue());
        }
    }
}

