/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import org.eclipse.papyrus.layers.stackmodel.NotFoundException;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertySetterRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.impl.PropertySetterImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class PropertySetterRegistryImplTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testPropertySetterRegistryImpl() {
        PropertySetterRegistry registry = LayersFactory.eINSTANCE.createPropertySetterRegistry();
        Assert.assertNotNull((String)"registry created", (Object)registry);
    }

    @Test
    public void testGetPropertySetters() {
        PropertySetterRegistry registry = LayersFactory.eINSTANCE.createPropertySetterRegistry();
        Assert.assertNotNull((String)"property setters can be retrieved", registry.getPropertySetters());
    }

    @Test
    public void testGetSetterMap() {
        PropertySetterRegistry registry = LayersFactory.eINSTANCE.createPropertySetterRegistry();
        Assert.assertNotNull((String)"map can be retrieved", registry.getSetterMap());
    }

    @Test
    public void testGetApplication() {
        PropertySetterRegistry registry = LayersFactory.eINSTANCE.createPropertySetterRegistry();
        Assert.assertNull((String)"application is not set", (Object)registry.getApplication());
    }

    @Test
    @Ignore
    public void testSetApplication() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testGetPropertySetterProperty() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testGetPropertySetterString() throws NotFoundException {
        PropertySetterRegistry registry = LayersFactory.eINSTANCE.createPropertySetterRegistry();
        Assert.assertNotNull((String)"Default property can be retrieved", (Object)registry.getPropertySetter("isValid"));
    }

    @Test
    public void testAddPropertySetter() throws NotFoundException {
        PropertySetterRegistry registry = LayersFactory.eINSTANCE.createPropertySetterRegistry();
        PropertySetterImpl setter = new PropertySetterImpl(){

            @Override
            public String getPropertyName() {
                return "myProperty";
            }
        };
        registry.addPropertySetter(setter);
        Assert.assertNotNull((String)"property can be retrieved from map", (Object)registry.getSetterMap().get((Object)"myProperty"));
        Assert.assertNotNull((String)"property can be retrieved from dedicated method", (Object)registry.getPropertySetter("myProperty"));
    }
}

