/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.layers.stackmodel.layers.Layer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertyRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.TypeInstance;
import org.eclipse.papyrus.layers.stackmodel.layers.impl.LayerImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LayerImplGetComputeCommandTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLayerImpl() {
        Layer layer = LayersFactory.eINSTANCE.createLayer();
        Assert.assertNotNull((String)"object created", (Object)layer);
    }

    @Test
    public void testGetComputePropertyValueCommand() throws LayersException {
        LayerImpl layer = (LayerImpl)LayersFactory.eINSTANCE.createLayer();
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        layer.setApplication(application);
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        int index = 0;
        Property property = (Property)propertyRegistry.getProperties().get(index);
        TypeInstance instance = property.createInstance();
        layer.getPropertyValueMap().put((Object)property.getName(), (Object)instance);
        Property property2 = (Property)propertyRegistry.getProperties().get(++index);
        TypeInstance instance2 = property2.createInstance();
        layer.getPropertyValueMap().put((Object)property2.getName(), (Object)instance2);
        Property property3 = (Property)propertyRegistry.getProperties().get(++index);
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        layer.getViews().add((Object)view1);
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        ComputePropertyValueCommand cmd = layer.getComputePropertyValueCommand((View)view1, property);
        Assert.assertNotNull((String)"cmd created", (Object)cmd);
        Assert.assertSame((String)"cmd s the property instance", (Object)instance, (Object)cmd);
        ComputePropertyValueCommand cmd2 = layer.getComputePropertyValueCommand((View)view2, property);
        Assert.assertNull((String)"cmd created", (Object)cmd2);
        ComputePropertyValueCommand cmd3 = layer.getComputePropertyValueCommand((View)view2, property3);
        Assert.assertNull((String)"cmd created", (Object)cmd3);
    }

    @Test
    public void testGetViewsComputePropertyValueCommandListOfViewProperty() throws LayersException {
        LayerImpl layer = (LayerImpl)LayersFactory.eINSTANCE.createLayer();
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        layer.setApplication(application);
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        int index = 0;
        Property property = (Property)propertyRegistry.getProperties().get(index);
        TypeInstance instance = property.createInstance();
        layer.getPropertyValueMap().put((Object)property.getName(), (Object)instance);
        Property property2 = (Property)propertyRegistry.getProperties().get(++index);
        TypeInstance instance2 = property2.createInstance();
        layer.getPropertyValueMap().put((Object)property2.getName(), (Object)instance2);
        Property property3 = (Property)propertyRegistry.getProperties().get(++index);
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        layer.getViews().add((Object)view1);
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        Shape view3 = NotationFactory.eINSTANCE.createShape();
        layer.getViews().add((Object)view3);
        EList<ComputePropertyValueCommand> cmds = layer.getViewsComputePropertyValueCommand(Arrays.asList(view1, view3), property);
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)2, (Object)cmds.size());
        int i = 0;
        Assert.assertSame((String)"cmd is the property instance", (Object)instance, cmds.get(i++));
        Assert.assertSame((String)"cmd is the property instance", (Object)instance, cmds.get(i++));
        EList<ComputePropertyValueCommand> cmds2 = layer.getViewsComputePropertyValueCommand(Arrays.asList(view1, view2), property);
        Assert.assertNotNull((String)"cmd created", cmds2);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)2, (Object)cmds2.size());
        i = 0;
        Assert.assertSame((String)"cmd is the property instance", (Object)instance, cmds2.get(i++));
        Assert.assertSame((String)"cmd is the property instance", null, cmds2.get(i++));
        EList<ComputePropertyValueCommand> cmds21 = layer.getViewsComputePropertyValueCommand(Arrays.asList(view2), property);
        Assert.assertNull((String)"cmd created", cmds21);
        EList<ComputePropertyValueCommand> cmds3 = layer.getViewsComputePropertyValueCommand(Arrays.asList(view1), property3);
        Assert.assertNull((String)"cmd created", cmds3);
        cmds = layer.getViewsComputePropertyValueCommand(Arrays.asList(view1, null, view3), property);
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)3, (Object)cmds.size());
        i = 0;
        Assert.assertSame((String)"cmd is the property instance", (Object)instance, cmds.get(i++));
        Assert.assertSame((String)"cmd is null", null, cmds.get(i++));
        Assert.assertSame((String)"cmd is the property instance", (Object)instance, cmds.get(i++));
    }

    @Test
    public void testGetPropertiesComputePropertyValueCommandViewListOfProperty() throws LayersException {
        LayerImpl layer = (LayerImpl)LayersFactory.eINSTANCE.createLayer();
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        layer.setApplication(application);
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        int index = 0;
        Property property = (Property)propertyRegistry.getProperties().get(index);
        TypeInstance instance = property.createInstance();
        layer.getPropertyValueMap().put((Object)property.getName(), (Object)instance);
        Property property2 = (Property)propertyRegistry.getProperties().get(++index);
        TypeInstance instance2 = property2.createInstance();
        layer.getPropertyValueMap().put((Object)property2.getName(), (Object)instance2);
        Property property3 = (Property)propertyRegistry.getProperties().get(++index);
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        layer.getViews().add((Object)view1);
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        Shape view3 = NotationFactory.eINSTANCE.createShape();
        layer.getViews().add((Object)view3);
        EList<ComputePropertyValueCommand> cmds = layer.getPropertiesComputePropertyValueCommand((View)view1, Arrays.asList(property, property2));
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)2, (Object)cmds.size());
        int i = 0;
        Assert.assertSame((String)"cmd is the property instance", (Object)instance, cmds.get(i++));
        Assert.assertSame((String)"cmd is the property instance", (Object)instance2, cmds.get(i++));
        cmds = layer.getPropertiesComputePropertyValueCommand((View)view1, Arrays.asList(property, property3));
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)2, (Object)cmds.size());
        i = 0;
        Assert.assertSame((String)"cmd is the property instance", (Object)instance, cmds.get(i++));
        Assert.assertSame((String)"cmd is the property instance", null, cmds.get(i++));
        cmds = layer.getPropertiesComputePropertyValueCommand((View)view1, Arrays.asList(property3));
        Assert.assertNull((String)"cmd created", cmds);
        cmds = layer.getPropertiesComputePropertyValueCommand((View)view2, Arrays.asList(property, property2));
        Assert.assertNull((String)"cmd created", cmds);
        cmds = layer.getPropertiesComputePropertyValueCommand((View)view1, Arrays.asList(property, null, property2));
        Assert.assertNotNull((String)"cmd created", cmds);
        Assert.assertSame((String)"cmd size is equals to views size", (Object)3, (Object)cmds.size());
        i = 0;
        Assert.assertSame((String)"cmd is the property instance", (Object)instance, cmds.get(i++));
        Assert.assertSame((String)"cmd is null", null, cmds.get(i++));
        Assert.assertSame((String)"cmd is the property instance", (Object)instance2, cmds.get(i++));
    }
}

