/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.exprmatcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.layers.stackmodel.Activator;
import org.eclipse.papyrus.layers.stackmodel.exprmatcher.IValueChangedEventListener;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class ValueChangedEventNotifier
extends EContentAdapter {
    boolean isDisposed = false;
    protected List<IValueChangedEventListener> listeners = new ArrayList<IValueChangedEventListener>();

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (this.isDiagramRootView(notification)) {
            this.fireValueChangedEvent(notification);
        } else if (this.isUmlDomainElementChanged(notification)) {
            this.fireValueChangedEvent(notification);
        }
    }

    private boolean isUmlDomainElementChanged(Notification notification) {
        if (!(notification.getNotifier() instanceof NamedElement)) {
            return false;
        }
        Object feature = notification.getFeature();
        if (feature == UMLPackage.eINSTANCE.getNamedElement_Name()) {
            switch (notification.getEventType()) {
                case 1: 
                case 3: 
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isDiagramRootView(Notification notification) {
        if (!(notification.getNotifier() instanceof Diagram)) {
            return false;
        }
        Object feature = notification.getFeature();
        if (feature == NotationPackage.eINSTANCE.getView_PersistedChildren() || feature == NotationPackage.eINSTANCE.getView_TransientChildren() || feature == NotationPackage.eINSTANCE.getDiagram_PersistedEdges() || feature == NotationPackage.eINSTANCE.getDiagram_TransientEdges()) {
            switch (notification.getEventType()) {
                case 1: 
                case 3: 
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isAdapterForType(Object type) {
        return type == ValueChangedEventNotifier.class;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.isDisposed = true;
        this.listeners.clear();
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void addEventListener(IValueChangedEventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeEventListener(IValueChangedEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireValueChangedEvent(Notification msg) {
        for (IValueChangedEventListener listener : this.listeners) {
            listener.valueChanged(msg);
        }
    }

    protected void selfAdapt(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".selfAdapt(" + notification + ")");
        }
        if (notification.getFeature() == NotationPackage.eINSTANCE.getView_Element()) {
            this.handleContainment(notification);
        } else {
            super.selfAdapt(notification);
        }
    }

    protected void setTarget(EObject target) {
        EObject extraTarget;
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".setTarget(" + target + ")");
        }
        if (target instanceof View && (extraTarget = ((View)target).getElement()) != null) {
            Activator.log.info(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".setExtraTarget(" + extraTarget + ")");
            this.addAdapter((Notifier)extraTarget);
        }
    }

    protected void unsetTarget(EObject target) {
        EObject extraTarget;
        super.unsetTarget(target);
        if (target instanceof View && (extraTarget = ((View)target).getElement()) != null) {
            this.removeAdapter((Notifier)extraTarget);
        }
    }
}

