/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.antsupport.inputhandler;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.eclipse.ant.internal.ui.antsupport.AntSupportMessages;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class AntInputHandler
extends DefaultInputHandler {
    public void handleInput(InputRequest request) throws BuildException {
        if (System.getProperty("eclipse.ant.noInput") != null) {
            throw new BuildException(AntSupportMessages.AntInputHandler_5);
        }
        BuildException[] problem = new BuildException[1];
        Runnable runnable = this.getHandleInputRunnable(request, problem);
        Display.getDefault().syncExec(runnable);
        if (problem[0] != null) {
            throw problem[0];
        }
    }

    protected Runnable getHandleInputRunnable(final InputRequest request, final BuildException[] problem) {
        return new Runnable(){

            @Override
            public void run() {
                String prompt = AntInputHandler.this.getPrompt(request);
                String title = AntSupportMessages.AntInputHandler_Ant_Input_Request_1;
                IInputValidator validator = new IInputValidator(){
                    private boolean fFirstValidation = true;

                    public String isValid(String value) {
                        request.setInput(value);
                        if (request.isInputValid()) {
                            return null;
                        }
                        if (this.fFirstValidation) {
                            this.fFirstValidation = false;
                            return "";
                        }
                        return AntSupportMessages.AntInputHandler_Invalid_input_2;
                    }
                };
                String initialValue = null;
                try {
                    request.getClass().getMethod("getDefaultValue", new Class[0]);
                    initialValue = request.getDefaultValue();
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                InputDialog dialog = new InputDialog(null, title, prompt, initialValue, validator){

                    protected int getShellStyle() {
                        return super.getShellStyle() | 0x10;
                    }
                };
                if (dialog.open() != 0) {
                    problem[0] = new BuildException(AntSupportMessages.AntInputHandler_Unable_to_respond_to__input__request_4);
                }
            }
        };
    }
}

