/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.validation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.validation.internal.util.XmlConstraintDescriptor;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.xml.XmlConstraintProvider;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.validation.LoadableConstraintDescriptor;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoadableConstraintProvider
extends XmlConstraintProvider {
    private static final Logger logger = Logger.getLogger(LoadableConstraintProvider.class);
    private static OCL ocl = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static OCL getOCL() {
        OCL ocl2 = ocl;
        if (ocl2 != null) return ocl2;
        Class<LoadableConstraintProvider> clazz = LoadableConstraintProvider.class;
        synchronized (LoadableConstraintProvider.class) {
            ocl2 = ocl;
            if (ocl2 != null) return ocl2;
            ocl = ocl2 = OCL.newInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ocl2;
        }
    }

    protected LoadableConstraintProvider() {
    }

    protected void installConstraint(@NonNull Constraint constraint, @NonNull Set<Category> categories) {
        MetaModelManager metaModelManager = ocl.getMetaModelManager();
        for (Element constrainedElement : constraint.getConstrainedElement()) {
            EModelElement targetElement;
            if (constrainedElement == null || (targetElement = metaModelManager.getEcoreOfPivot(EModelElement.class, constrainedElement)) == null) continue;
            int code = 99;
            LoadableConstraintDescriptor desc = null;
            if (targetElement instanceof EClassifier) {
                desc = new LoadableConstraintDescriptor.Ecore((EClassifier)targetElement, constraint, code);
            } else if (targetElement instanceof Stereotype) {
                desc = new LoadableConstraintDescriptor.UML((Stereotype)targetElement, constraint, code);
            } else {
                logger.error((Object)("Unknown constrainedElement type : " + targetElement));
            }
            if (desc == null) continue;
            for (Category category : categories) {
                category.addConstraint((IConstraintDescriptor)desc);
            }
            List constraints = this.getConstraints();
            constraints.add(desc);
        }
    }

    protected void installContents(Iterable<? extends EObject> eContents, @NonNull Set<Category> categories) {
        for (EObject eObject : eContents) {
            if (eObject instanceof Constraint) {
                this.installConstraint((Constraint)eObject, categories);
            }
            if (eObject instanceof EAnnotation || eObject instanceof Annotation) continue;
            this.installContents((Iterable<? extends EObject>)eObject.eContents(), categories);
        }
    }

    protected void installDescriptor(@NonNull XmlConstraintDescriptor descriptor, String namespaceIdentifier, @NonNull Set<Category> categories) {
        String path = descriptor.getParameterValue("path");
        URI uri = URI.createPlatformPluginURI((String)("/" + namespaceIdentifier + "/" + path), (boolean)true);
        MetaModelManager metaModelManager = LoadableConstraintProvider.getOCL().getMetaModelManager();
        this.load(metaModelManager, uri, categories);
    }

    protected boolean installResource(@NonNull Resource asResource, @NonNull Set<Category> categories) {
        EList errors = asResource.getErrors();
        assert (errors != null);
        String message = PivotUtil.formatResourceDiagnostics((List<Resource.Diagnostic>)errors, "", "\n");
        if (message != null) {
            logger.error((Object)("Failed to load Pivot from '" + (Object)((Object)this) + "': " + message));
            return false;
        }
        this.installContents((Iterable<? extends EObject>)asResource.getContents(), categories);
        try {
            this.registerConstraints(this.getConstraints());
        }
        catch (ConstraintExistsException e) {
            logger.error((Object)("Duplicate constraint for '" + (Object)((Object)this) + "'"), (Throwable)e);
        }
        return true;
    }

    protected abstract boolean load(@NonNull MetaModelManager var1, @NonNull URI var2, @NonNull Set<Category> var3);

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
        Object cfg = config;
        while (cfg instanceof IConfigurationElement) {
            cfg = cfg.getParent();
        }
        if (!(cfg instanceof IExtension)) {
            logger.error((Object)("The ConstraintDescriptor for '" + config.getName() + "' has no IExtension parent"), null);
            return;
        }
        String namespaceIdentifier = ((IExtension)cfg).getNamespaceIdentifier();
        ArrayList oldConstraints = new ArrayList(this.getConstraints());
        HashSet<Category> categories = new HashSet<Category>();
        for (IModelConstraint constraint : oldConstraints) {
            IConstraintDescriptor descriptor = constraint.getDescriptor();
            if (descriptor == null) continue;
            categories.addAll(descriptor.getCategories());
        }
        HashSet allDescriptors = new HashSet();
        for (Category category : categories) {
            allDescriptors.addAll(category.getConstraints());
        }
        for (IConstraintDescriptor descriptor : allDescriptors) {
            if (descriptor instanceof LoadableConstraintDescriptor) continue;
            for (Category category : categories) {
                category.removeConstraint(descriptor);
            }
        }
        for (IModelConstraint constraint : oldConstraints) {
            IConstraintDescriptor descriptor = constraint.getDescriptor();
            if (descriptor == null) continue;
            this.installDescriptor((XmlConstraintDescriptor)descriptor, namespaceIdentifier, categories);
        }
    }

    public String toString() {
        return "LoadableConstraintProvider";
    }
}

