/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.ASSaver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASSaverLocateVisitor
extends AbstractExtendingVisitor<Object, ASSaver> {
    public ASSaverLocateVisitor(@NonNull ASSaver context) {
        super(context);
    }

    @Override
    public Object visitClass(@NonNull Class object) {
        for (Type superClass : object.getSuperClass()) {
            if (superClass.getTemplateBinding().size() <= 0) continue;
            ((ASSaver)this.context).addSpecializingElement(object);
            break;
        }
        return null;
    }

    @Override
    public Object visitCollectionType(@NonNull CollectionType object) {
        Type referredType = object.getElementType();
        if (referredType != null) {
            ((ASSaver)this.context).addSpecializingElement((Element)object, referredType);
        }
        return super.visitCollectionType(object);
    }

    @Override
    public Object visitLambdaType(@NonNull LambdaType object) {
        boolean doneIt = false;
        Type referredType = object.getContextType();
        if (referredType != null && ((ASSaver)this.context).addSpecializingElement((Element)object, referredType)) {
            doneIt = true;
        }
        if (!doneIt) {
            referredType = object.getResultType();
            if (referredType != null && ((ASSaver)this.context).addSpecializingElement((Element)object, referredType)) {
                doneIt = true;
            }
            if (!doneIt) {
                for (Type parameterType : object.getParameterType()) {
                    if (parameterType != null && ((ASSaver)this.context).addSpecializingElement((Element)object, parameterType)) break;
                }
            }
        }
        return super.visitLambdaType(object);
    }

    @Override
    public Object visitLoopExp(@NonNull LoopExp object) {
        Iteration referredIteration = object.getReferredIteration();
        if (referredIteration != null) {
            ((ASSaver)this.context).addSpecializingElement((Element)object, referredIteration);
        }
        return super.visitLoopExp(object);
    }

    @Override
    public Object visitOperationCallExp(@NonNull OperationCallExp object) {
        Operation referredOperation = object.getReferredOperation();
        if (referredOperation != null) {
            ((ASSaver)this.context).addSpecializingElement((Element)object, referredOperation);
        }
        return super.visitOperationCallExp(object);
    }

    @Override
    public Object visitProperty(@NonNull Property object) {
        Property opposite = object.getOpposite();
        if (opposite != null) {
            Resource eResource = opposite.eResource();
            assert (eResource != null);
        }
        return super.visitProperty(object);
    }

    @Override
    public Object visitTemplateParameterSubstitution(@NonNull TemplateParameterSubstitution object) {
        ParameterableElement actual = object.getActual();
        if (actual instanceof Type) {
            ((ASSaver)this.context).addSpecializingElement((Element)object, (Type)actual);
        }
        return null;
    }

    @Override
    public Object visitTypedElement(@NonNull TypedElement object) {
        Type referredType = object.getType();
        if (referredType != null) {
            ((ASSaver)this.context).addSpecializingElement((Element)object, referredType);
        }
        return null;
    }

    @Override
    public Object visitTypeTemplateParameter(@NonNull TypeTemplateParameter object) {
        for (Type constrainingType : object.getConstrainingType()) {
            if (constrainingType != null && ((ASSaver)this.context).addSpecializingElement((Element)object, constrainingType)) break;
        }
        return null;
    }

    @Override
    public Object visiting(@NonNull Visitable visitable) {
        return null;
    }
}

