/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.common.utils.EcoreUtils;
import org.eclipse.ocl.examples.common.utils.TracingOption;
import org.eclipse.ocl.examples.domain.elements.DomainConstraint;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Stereotype;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.uml.UML2Pivot;
import org.eclipse.ocl.examples.pivot.uml.UML2PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.ConstraintEvaluator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLOCLEValidator
implements EValidator {
    @NonNull
    public static final UMLOCLEValidator INSTANCE = new UMLOCLEValidator(true);
    @NonNull
    public static final UMLOCLEValidator NO_NEW_LINES = new UMLOCLEValidator(false);
    @NonNull
    public static final TracingOption VALIDATE_INSTANCE = new TracingOption("org.eclipse.ocl.examples.pivot", "validate/instance");
    @NonNull
    public static final TracingOption VALIDATE_OPAQUE_ELEMENT = new TracingOption("org.eclipse.ocl.examples.pivot", "validate/opaqueElement");
    protected final boolean mayUseNewLines;

    protected static void gatherClassifiers(@NonNull Set<Classifier> allClassifiers, @NonNull Set<Constraint> allConstraints, @NonNull Classifier newClassifier) {
        if (allClassifiers.add(newClassifier)) {
            allConstraints.addAll((Collection<Constraint>)newClassifier.getOwnedRules());
            if (newClassifier instanceof Class) {
                for (Classifier classifier : ((Class)newClassifier).getSuperClasses()) {
                    if (classifier == null) continue;
                    UMLOCLEValidator.gatherClassifiers(allClassifiers, allConstraints, classifier);
                }
            }
        }
    }

    protected static void gatherTypes(@NonNull Set<Type> allTypes, @NonNull Set<DomainConstraint> allConstraints, @NonNull Type newType) {
        if (allTypes.add(newType)) {
            allConstraints.addAll(newType.getOwnedInvariant());
            for (Type superType : newType.getSuperClass()) {
                if (superType == null) continue;
                UMLOCLEValidator.gatherTypes(allTypes, allConstraints, superType);
            }
        }
    }

    public UMLOCLEValidator(boolean mayUseNewLines) {
        this.mayUseNewLines = mayUseNewLines;
    }

    protected OCL getOCL(@NonNull Map<Object, Object> context) {
        OCL ocl = null;
        Object oclRef = context.get(WeakOCLReference.class);
        if (oclRef instanceof WeakOCLReference) {
            ocl = (OCL)((WeakOCLReference)oclRef).get();
        }
        if (ocl == null) {
            ocl = OCL.newInstance();
            context.put(WeakOCLReference.class, new WeakOCLReference(ocl));
        }
        return ocl;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        assert (context != null);
        boolean allOk = true;
        if (eObject instanceof org.eclipse.uml2.uml.OpaqueExpression) {
            org.eclipse.uml2.uml.OpaqueExpression opaqueExpression = (org.eclipse.uml2.uml.OpaqueExpression)eObject;
            EList languages = opaqueExpression.getLanguages();
            EList bodies = opaqueExpression.getBodies();
            allOk = this.validateOpaqueElement((List<String>)languages, (List<String>)bodies, (Element)opaqueExpression, diagnostics, context);
        } else if (eObject instanceof InstanceSpecification) {
            allOk = this.validateInstanceSpecification((InstanceSpecification)eObject, diagnostics, context);
        }
        try {
            if (eObject instanceof Element) {
                Resource umlResource;
                EList umlStereotypeApplications = ((Element)eObject).getStereotypeApplications();
                if (umlStereotypeApplications.size() > 0 && (umlResource = ((EObject)umlStereotypeApplications.get(0)).eClass().eResource()) != null) {
                    OCL ocl = this.getOCL(context);
                    MetaModelManager metaModelManager = ocl.getMetaModelManager();
                    UML2Pivot uml2pivot = UML2Pivot.getAdapter(umlResource, metaModelManager);
                    uml2pivot.getPivotRoot();
                    Map<EObject, List<Element>> umlStereotypeApplication2umlStereotypedElements = UML2PivotUtil.computeAppliedStereotypes((Iterable<EObject>)umlStereotypeApplications);
                    for (EObject umlStereotypeApplication : umlStereotypeApplications) {
                        List<Element> umlStereotypedElements;
                        Stereotype stereotype = uml2pivot.resolveStereotype(umlStereotypeApplication, umlStereotypedElements = umlStereotypeApplication2umlStereotypedElements.get(umlStereotypeApplication));
                        if (stereotype == null) continue;
                        HashSet<Type> allClassifiers = new HashSet<Type>();
                        HashSet<DomainConstraint> allConstraints = new HashSet<DomainConstraint>();
                        UMLOCLEValidator.gatherTypes(allClassifiers, allConstraints, stereotype);
                        for (DomainConstraint constraint : allConstraints) {
                            EvaluationVisitor evaluationVisitor;
                            ConstraintEvaluator constraintEvaluator;
                            ExpressionInOCL asExpression;
                            DomainExpression specification = constraint.getSpecification();
                            if (!(specification instanceof OpaqueExpression) || (asExpression = ((OpaqueExpression)specification).getExpressionInOCL()) == null || ((Boolean)(constraintEvaluator = diagnostics != null ? new ConstraintEvaluatorWithDiagnostics(asExpression, umlStereotypeApplication, diagnostics, eObject, this.mayUseNewLines) : new ConstraintEvaluatorWithoutDiagnostics(asExpression)).evaluate(evaluationVisitor = ocl.createEvaluationVisitor(umlStereotypeApplication, asExpression))).booleanValue() || diagnostics != null) continue;
                            allOk = false;
                        }
                    }
                }
                return allOk;
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    protected boolean validateInstance(@NonNull EObject instanceSpecification, @NonNull org.eclipse.uml2.uml.OpaqueExpression opaqueExpression, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        if (context != null) {
            EList bodies = opaqueExpression.getBodies();
            EList languages = opaqueExpression.getLanguages();
            int i = 0;
            while (i < bodies.size()) {
                try {
                    String body;
                    String language;
                    String string = language = i < languages.size() ? (String)languages.get(i) : "OCL";
                    if ((i >= languages.size() || "OCL".equals(languages.get(i))) && (body = (String)bodies.get(i)) != null) {
                        if (VALIDATE_INSTANCE.isActive()) {
                            VALIDATE_INSTANCE.println(String.valueOf(language) + ": " + body);
                        }
                        if (!this.validateSyntax(instanceSpecification, body, (Element)opaqueExpression, diagnostics, context) && diagnostics == null) {
                            allOk = false;
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    if (diagnostics != null) {
                        String objectLabel = EObjectValidator.getObjectLabel((EObject)opaqueExpression, context);
                        String message = NLS.bind((String)"Body processing error {0} on {1}", (Object)e, (Object)objectLabel);
                        diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 0, message, new Object[]{opaqueExpression}));
                    }
                    allOk = false;
                }
                ++i;
            }
        }
        return allOk;
    }

    public boolean validateInstanceSpecification(@NonNull InstanceSpecification instanceSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        HashSet<Classifier> allClassifiers = new HashSet<Classifier>();
        HashSet<Constraint> allConstraints = new HashSet<Constraint>();
        for (Classifier classifier : instanceSpecification.getClassifiers()) {
            if (classifier == null) continue;
            UMLOCLEValidator.gatherClassifiers(allClassifiers, allConstraints, classifier);
        }
        boolean allOk = true;
        for (Constraint constraint : allConstraints) {
            org.eclipse.uml2.uml.OpaqueExpression opaqueExpression;
            ValueSpecification specification = constraint.getSpecification();
            if (!(specification instanceof org.eclipse.uml2.uml.OpaqueExpression) || this.validateInstance((EObject)instanceSpecification, opaqueExpression = (org.eclipse.uml2.uml.OpaqueExpression)specification, diagnostics, context) || diagnostics != null) continue;
            allOk = false;
        }
        return allOk;
    }

    public boolean validateOpaqueAction(@NonNull OpaqueAction opaqueAction, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return INSTANCE.validateOpaqueElement((List<String>)opaqueAction.getLanguages(), (List<String>)opaqueAction.getBodies(), (Element)opaqueAction, diagnostics, context);
    }

    public boolean validateOpaqueBehavior(@NonNull OpaqueBehavior opaqueBehavior, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return INSTANCE.validateOpaqueElement((List<String>)opaqueBehavior.getLanguages(), (List<String>)opaqueBehavior.getBodies(), (Element)opaqueBehavior, diagnostics, context);
    }

    public boolean validateOpaqueExpression(@NonNull org.eclipse.uml2.uml.OpaqueExpression opaqueExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return INSTANCE.validateOpaqueElement((List<String>)opaqueExpression.getLanguages(), (List<String>)opaqueExpression.getBodies(), (Element)opaqueExpression, diagnostics, context);
    }

    protected boolean validateOpaqueElement(List<String> languages, List<String> bodies, @NonNull Element opaqueElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        if (context != null) {
            int i = 0;
            while (i < bodies.size()) {
                if (i >= languages.size() || "OCL".equals(languages.get(i))) {
                    try {
                        String body = bodies.get(i);
                        if (body != null) {
                            if (VALIDATE_OPAQUE_ELEMENT.isActive()) {
                                VALIDATE_OPAQUE_ELEMENT.println("OCL: " + body);
                            }
                            if (!this.validateSyntax(null, body, opaqueElement, diagnostics, context) && diagnostics == null) {
                                allOk = false;
                                break;
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (diagnostics != null) {
                            String objectLabel = EObjectValidator.getObjectLabel((EObject)opaqueElement, context);
                            String message = NLS.bind((String)"Body language processing error {0} on {1}", (Object)e, (Object)objectLabel);
                            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 0, message, new Object[]{opaqueElement}));
                        }
                        allOk = false;
                    }
                }
                ++i;
            }
        }
        return allOk;
    }

    protected boolean validateSyntax(@Nullable EObject instance, @NonNull String body, @NonNull Element opaqueElement, @Nullable DiagnosticChain diagnostics, @NonNull Map<Object, Object> context) {
        OpaqueExpression asElement;
        ExpressionInOCL asExpression;
        OCL ocl;
        block8: {
            ocl = this.getOCL(context);
            asExpression = null;
            try {
                MetaModelManager metaModelManager = ocl.getMetaModelManager();
                asElement = metaModelManager.getPivotOf(OpaqueExpression.class, (EObject)opaqueElement);
                if (asElement != null) break block8;
                if (diagnostics != null) {
                    String objectLabel = DomainUtil.getLabel((EObject)opaqueElement);
                    String message = DomainUtil.bind((String)"No pivot for {0}", (Object[])new Object[]{objectLabel});
                    if (!this.mayUseNewLines) {
                        message = message.replace("\n", " ");
                    }
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 0, message, new Object[]{opaqueElement}));
                }
                return false;
            }
            catch (ParserException e) {
                if (diagnostics != null) {
                    String objectLabel = DomainUtil.getLabel((EObject)opaqueElement);
                    String message = DomainUtil.bind((String)OCLMessages.ParsingError, (Object[])new Object[]{objectLabel, e.getMessage()});
                    if (!this.mayUseNewLines) {
                        message = message.replace("\n", " ");
                    }
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 0, message, new Object[]{opaqueElement}));
                }
                return false;
            }
        }
        asExpression = asElement.getValidExpressionInOCL();
        if (instance != null) {
            EvaluationVisitor evaluationVisitor = ocl.createEvaluationVisitor(instance, asExpression);
            ConstraintEvaluator constraintEvaluator = diagnostics != null ? new ConstraintEvaluatorWithDiagnostics(asExpression, instance, diagnostics, instance, this.mayUseNewLines) : new ConstraintEvaluatorWithoutDiagnostics(asExpression);
            return (Boolean)constraintEvaluator.evaluate(evaluationVisitor);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstraintEvaluatorWithDiagnostics
    extends ConstraintEvaluator<Boolean> {
        @NonNull
        protected final EObject eObject;
        @NonNull
        protected final DiagnosticChain diagnostics;
        @NonNull
        protected final EObject diagnosticEObject;
        protected final boolean mayUseNewLines;

        public ConstraintEvaluatorWithDiagnostics(@NonNull ExpressionInOCL expression, @NonNull EObject eObject, @NonNull DiagnosticChain diagnostics, @NonNull EObject diagnosticEObject, boolean mayUseNewLines) {
            super(expression);
            this.diagnosticEObject = diagnosticEObject;
            this.eObject = eObject;
            this.diagnostics = diagnostics;
            this.mayUseNewLines = mayUseNewLines;
        }

        @Override
        protected String getObjectLabel() {
            return EcoreUtils.qualifiedNameFor((Object)this.eObject);
        }

        @Override
        protected Boolean handleExceptionResult(@NonNull Throwable e) {
            String message = DomainUtil.bind((String)OCLMessages.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.toString()});
            if (!this.mayUseNewLines) {
                message = message.replace("\n", "");
            }
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 0, message, new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleFailureResult(@Nullable Object result) {
            int severity = this.getConstraintResultSeverity(result);
            String message = this.getConstraintResultMessage(result);
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.uml2.uml", 0, message, new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleInvalidExpression(@NonNull String message) {
            String message2 = message;
            if (!this.mayUseNewLines) {
                message2 = message.replace("\n", "");
            }
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message2.replace("\n", " - "), new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleInvalidResult(@NonNull InvalidValueException e) {
            String message = DomainUtil.bind((String)OCLMessages.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.getLocalizedMessage()});
            if (!this.mayUseNewLines) {
                message = message.replace("\n", "");
            }
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 0, message, new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleSuccessResult() {
            return Boolean.TRUE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstraintEvaluatorWithoutDiagnostics
    extends ConstraintEvaluator<Boolean> {
        public ConstraintEvaluatorWithoutDiagnostics(@NonNull ExpressionInOCL expression) {
            super(expression);
        }

        @Override
        protected String getObjectLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Boolean handleExceptionResult(@NonNull Throwable e) {
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleFailureResult(@Nullable Object result) {
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleInvalidExpression(@NonNull String message) {
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleInvalidResult(@NonNull InvalidValueException e) {
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleSuccessResult() {
            return Boolean.TRUE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class WeakOCLReference
    extends WeakReference<OCL> {
        @NonNull
        protected final OCL ocl;

        protected WeakOCLReference(@NonNull OCL ocl) {
            super(ocl);
            this.ocl = ocl;
        }

        public void finalize() {
            new Thread("OCL-Finalizer"){

                public void run() {
                    WeakOCLReference.this.ocl.dispose();
                }
            }.start();
        }
    }
}

