/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.uml.Pivot2UMLDeclarationVisitor;
import org.eclipse.ocl.examples.pivot.uml.Pivot2UMLReferenceVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2UML
extends AbstractConversion {
    private Map<Element, EModelElement> createMap = new HashMap<Element, EModelElement>();
    Set<Element> deferMap = new HashSet<Element>();
    private List<Resource.Diagnostic> errors = null;
    protected final Pivot2UMLDeclarationVisitor pass1 = new Pivot2UMLDeclarationVisitor(this);
    protected final Pivot2UMLReferenceVisitor pass2 = new Pivot2UMLReferenceVisitor(this);

    public static List<EObject> createResource(@NonNull MetaModelManager metaModelManager, @NonNull Resource asResource) {
        EList pivotRoots = asResource.getContents();
        Pivot2UML converter = new Pivot2UML(metaModelManager);
        return converter.convertAll((List<? extends EObject>)pivotRoots);
    }

    public Pivot2UML(@NonNull MetaModelManager metaModelManager) {
        super(metaModelManager);
    }

    @Nullable
    protected EObject convert(@NonNull Element pivotObject) {
        EObject eObject = (EObject)this.pass1.safeVisit(pivotObject);
        for (Element eKey : this.deferMap) {
            this.pass2.safeVisit(eKey);
        }
        return eObject;
    }

    @NonNull
    protected List<EObject> convertAll(@NonNull List<? extends EObject> pivotObjects) {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        for (EObject eObject : pivotObjects) {
            if (!(eObject instanceof Element)) continue;
            eObjects.add((EObject)this.pass1.safeVisit((Visitable)eObject));
        }
        for (Element element : this.deferMap) {
            this.pass2.safeVisit(element);
        }
        return eObjects;
    }

    protected void error(@NonNull String message) {
        if (this.errors == null) {
            this.errors = new ArrayList<Resource.Diagnostic>();
        }
        this.errors.add((Resource.Diagnostic)new XMIException(message));
    }

    public void defer(@NonNull Element pivotElement) {
        this.deferMap.add(pivotElement);
    }

    public <T extends EObject> T getCreated(@NonNull Class<T> requiredClass, @NonNull Element pivotElement) {
        EModelElement eModelElement = this.createMap.get(pivotElement);
        if (eModelElement == null) {
            return null;
        }
        if (!requiredClass.isAssignableFrom(eModelElement.getClass())) {
            throw new ClassCastException(String.valueOf(eModelElement.getClass().getName()) + " is not assignable to " + requiredClass.getName());
        }
        EModelElement castElement = eModelElement;
        return (T)castElement;
    }

    public void putCreated(@NonNull Element pivotElement, @NonNull EModelElement eModelElement) {
        EModelElement old = this.createMap.put(pivotElement, eModelElement);
        assert (old == null);
    }
}

