/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.resource;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.resource.ASResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASResourceFactoryRegistry {
    @NonNull
    public static final ASResourceFactoryRegistry INSTANCE = new ASResourceFactoryRegistry();
    @NonNull
    protected final Set<ASResourceFactory> asResourceFactories = new HashSet<ASResourceFactory>();
    @NonNull
    protected final Map<String, ASResourceFactory> contentType2resourceFactory = new HashMap<String, ASResourceFactory>();

    public synchronized void addASResourceFactory(@NonNull String contentType, @NonNull ASResourceFactory asResourceFactory) {
        this.asResourceFactories.add(asResourceFactory);
        this.contentType2resourceFactory.put(contentType, asResourceFactory);
    }

    public synchronized void configureResourceSet(@NonNull ResourceSet resourceSet) {
        for (ASResourceFactory asResourceFactory : this.asResourceFactories) {
            asResourceFactory.configure(resourceSet);
        }
    }

    @NonNull
    public Iterable<ASResourceFactory> getResourceFactories() {
        return this.asResourceFactories;
    }

    @Nullable
    public synchronized ASResourceFactory getResourceFactory(@Nullable EObject eObject) {
        if (eObject == null) {
            return null;
        }
        int bestPriority = -100;
        ASResourceFactory bestASResourceFactory = null;
        for (ASResourceFactory asResourceFactory : this.asResourceFactories) {
            int priority = asResourceFactory.getHandlerPriority(eObject);
            if (priority <= bestPriority) continue;
            bestASResourceFactory = asResourceFactory;
            bestPriority = priority;
        }
        return bestASResourceFactory;
    }

    @Nullable
    public synchronized ASResourceFactory getResourceFactory(@NonNull Resource resource) {
        int bestPriority = -100;
        ASResourceFactory bestASResourceFactory = null;
        for (ASResourceFactory asResourceFactory : this.asResourceFactories) {
            int priority = asResourceFactory.getHandlerPriority(resource);
            if (priority <= bestPriority) continue;
            bestASResourceFactory = asResourceFactory;
            bestPriority = priority;
        }
        return bestASResourceFactory;
    }

    @Nullable
    public synchronized ASResourceFactory getResourceFactory(@NonNull URI uri) {
        int bestPriority = -100;
        ASResourceFactory bestASResourceFactory = null;
        for (ASResourceFactory asResourceFactory : this.asResourceFactories) {
            int priority = asResourceFactory.getHandlerPriority(uri);
            if (priority <= bestPriority) continue;
            bestASResourceFactory = asResourceFactory;
            bestPriority = priority;
        }
        return bestASResourceFactory;
    }
}

