/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.prettyprint;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.Unlimited;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.ConstructorPart;
import org.eclipse.ocl.examples.pivot.EnumLiteralExp;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintVisitor;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class EssentialOCLPrettyPrintVisitor
extends PrettyPrintVisitor {
    public EssentialOCLPrettyPrintVisitor(@NonNull PrettyPrinter context) {
        super(context);
    }

    protected void appendSourceNavigation(@NonNull CallExp object) {
        OCLExpression source = object.getSource();
        if (!(source == null || source instanceof VariableExp && ((VariableExp)source).isImplicit())) {
            if (source instanceof OperationCallExp && ((OperationCallExp)source).getReferredOperation() != null && ((OperationCallExp)source).getReferredOperation().getPrecedence() != null) {
                ((PrettyPrinter)this.context).append("(");
                ((PrettyPrinter)this.context).precedenceVisit(source, null);
                ((PrettyPrinter)this.context).append(")");
            } else {
                this.safeVisit(source);
            }
            if (source.getType() instanceof CollectionType) {
                ((PrettyPrinter)this.context).append(object.isImplicit() ? "." : "->");
            } else if (!object.isImplicit()) {
                ((PrettyPrinter)this.context).append(".");
            }
        }
    }

    public Object visitBooleanLiteralExp(@NonNull BooleanLiteralExp object) {
        ((PrettyPrinter)this.context).append(Boolean.toString(object.isBooleanSymbol()));
        return null;
    }

    public Object visitCollectionItem(@NonNull CollectionItem object) {
        this.safeVisit(object.getItem());
        return null;
    }

    public Object visitCollectionLiteralExp(@NonNull CollectionLiteralExp object) {
        ((PrettyPrinter)this.context).appendName(object.getType(), ((PrettyPrinter)this.context).getReservedNames());
        List<CollectionLiteralPart> parts = object.getPart();
        if (parts.isEmpty()) {
            ((PrettyPrinter)this.context).append("{}");
        } else {
            ((PrettyPrinter)this.context).push("{", "");
            String prefix = "";
            for (CollectionLiteralPart part : parts) {
                ((PrettyPrinter)this.context).append(prefix);
                this.safeVisit(part);
                prefix = ", ";
            }
            ((PrettyPrinter)this.context).exdent("", "}", "");
            ((PrettyPrinter)this.context).pop();
        }
        return null;
    }

    public Object visitCollectionRange(@NonNull CollectionRange object) {
        this.safeVisit(object.getFirst());
        ((PrettyPrinter)this.context).next("", "..", "");
        this.safeVisit(object.getLast());
        return null;
    }

    public Object visitConstraint(@NonNull Constraint object) {
        String stereotype = PivotUtil.getStereotype(object);
        if ("body".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("body");
        } else if ("derivation".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("der");
        } else if ("initial".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("init");
        } else if ("invariant".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("inv");
        } else if ("postcondition".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("post");
        } else if ("precondition".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("pre");
        } else {
            ((PrettyPrinter)this.context).append(stereotype);
        }
        if (object.getName() != null) {
            ((PrettyPrinter)this.context).append(" ");
            ((PrettyPrinter)this.context).appendName(object);
        }
        ((PrettyPrinter)this.context).push(":", " ");
        this.safeVisit(object.getSpecification());
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    public Value visitConstructorExp(@NonNull ConstructorExp object) {
        Type type = object.getType();
        if (type != null) {
            ((PrettyPrinter)this.context).appendQualifiedType(type);
        }
        ((PrettyPrinter)this.context).push("{", "");
        String prefix = "";
        for (ConstructorPart part : object.getPart()) {
            ((PrettyPrinter)this.context).append(prefix);
            this.safeVisit(part);
            prefix = ", ";
        }
        ((PrettyPrinter)this.context).exdent("", "}", "");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    public String visitConstructorPart(@NonNull ConstructorPart part) {
        ((PrettyPrinter)this.context).appendName(part.getReferredProperty());
        OCLExpression initExpression = part.getInitExpression();
        if (initExpression != null) {
            ((PrettyPrinter)this.context).append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    public Object visitEnumLiteralExp(@NonNull EnumLiteralExp object) {
        this.safeVisit(object.getReferredEnumLiteral());
        return null;
    }

    public Object visitExpressionInOCL(@NonNull ExpressionInOCL object) {
        this.safeVisit(object.getBodyExpression());
        return null;
    }

    public Object visitIfExp(@NonNull IfExp object) {
        ((PrettyPrinter)this.context).push("if", " ");
        this.safeVisit(object.getCondition());
        ((PrettyPrinter)this.context).exdent(" ", "then", " ");
        this.safeVisit(object.getThenExpression());
        ((PrettyPrinter)this.context).exdent(" ", "else", " ");
        this.safeVisit(object.getElseExpression());
        ((PrettyPrinter)this.context).exdent(" ", "endif", "");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    public Object visitIntegerLiteralExp(@NonNull IntegerLiteralExp object) {
        ((PrettyPrinter)this.context).append(object.getIntegerSymbol());
        return null;
    }

    public Object visitInvalidLiteralExp(@NonNull InvalidLiteralExp object) {
        ((PrettyPrinter)this.context).append("invalid");
        return null;
    }

    public Object visitIterateExp(@NonNull IterateExp object) {
        Iteration referredIteration = object.getReferredIteration();
        OCLExpression body = object.getBody();
        Variable result = object.getResult();
        if (((PrettyPrinter)this.context).showNames()) {
            List<Variable> iterators = object.getIterator();
            this.appendSourceNavigation(object);
            ((PrettyPrinter)this.context).appendName(referredIteration);
            ((PrettyPrinter)this.context).push("(", "");
            String prefix = null;
            if (iterators.size() > 0) {
                boolean hasExplicitIterator = false;
                for (Variable iterator : iterators) {
                    if (iterator.isImplicit()) continue;
                    if (prefix != null) {
                        ((PrettyPrinter)this.context).next(null, prefix, " ");
                    }
                    ((PrettyPrinter)this.context).appendName(iterator);
                    prefix = ",";
                    hasExplicitIterator = true;
                }
                if (hasExplicitIterator) {
                    prefix = ";";
                }
                if (prefix != null) {
                    ((PrettyPrinter)this.context).next(null, prefix, " ");
                }
                this.safeVisit(result);
                ((PrettyPrinter)this.context).next(null, " |", " ");
            }
            this.safeVisit(body);
            ((PrettyPrinter)this.context).next("", ")", "");
            ((PrettyPrinter)this.context).pop();
        } else {
            Type sourceType;
            OCLExpression source = object.getSource();
            if (source != null && (sourceType = source.getType()) != null) {
                ((PrettyPrinter)this.context).appendQualifiedType(sourceType);
                ((PrettyPrinter)this.context).append("::");
            }
            ((PrettyPrinter)this.context).appendName(referredIteration);
            ((PrettyPrinter)this.context).push("(", "");
            String prefix = null;
            for (Variable iterator : object.getIterator()) {
                if (prefix != null) {
                    ((PrettyPrinter)this.context).next(null, prefix, " ");
                }
                ((PrettyPrinter)this.context).appendName(iterator);
                ((PrettyPrinter)this.context).append(" : ");
                this.safeVisit(iterator.getType());
                prefix = ",";
            }
            ((PrettyPrinter)this.context).next(null, ";", " ");
            ((PrettyPrinter)this.context).appendName(result);
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(result.getType());
            ((PrettyPrinter)this.context).next(null, " |", " ");
            this.safeVisit(body != null ? body.getType() : null);
            ((PrettyPrinter)this.context).next("", ")", "");
            ((PrettyPrinter)this.context).pop();
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(object.getType());
        }
        return null;
    }

    public Object visitIteratorExp(@NonNull IteratorExp object) {
        Iteration referredIteration = object.getReferredIteration();
        OCLExpression body = object.getBody();
        if (((PrettyPrinter)this.context).showNames()) {
            List<Variable> iterators = object.getIterator();
            this.appendSourceNavigation(object);
            if (object.isImplicit()) {
                assert (referredIteration.getName().equals("collect"));
                assert (iterators.size() == 1);
                this.safeVisit(body);
            } else {
                ((PrettyPrinter)this.context).appendName(referredIteration);
                ((PrettyPrinter)this.context).push("(", "");
                if (iterators.size() > 0) {
                    String prefix = null;
                    boolean hasExplicitIterator = false;
                    for (Variable iterator : iterators) {
                        if (iterator.isImplicit()) continue;
                        if (prefix != null) {
                            ((PrettyPrinter)this.context).next(null, prefix, " ");
                        }
                        ((PrettyPrinter)this.context).appendName(iterator);
                        prefix = ",";
                        hasExplicitIterator = true;
                    }
                    if (hasExplicitIterator) {
                        ((PrettyPrinter)this.context).next(null, " |", " ");
                    } else if (prefix != null) {
                        ((PrettyPrinter)this.context).next(null, prefix, " ");
                    }
                }
                this.safeVisit(body);
                ((PrettyPrinter)this.context).next("", ")", "");
                ((PrettyPrinter)this.context).pop();
            }
        } else {
            Type sourceType;
            OCLExpression source = object.getSource();
            if (source != null && (sourceType = source.getType()) != null) {
                ((PrettyPrinter)this.context).appendQualifiedType(sourceType);
                ((PrettyPrinter)this.context).append("::");
            }
            ((PrettyPrinter)this.context).appendName(referredIteration);
            ((PrettyPrinter)this.context).push("(", "");
            String prefix = null;
            for (Variable iterator : object.getIterator()) {
                if (prefix != null) {
                    ((PrettyPrinter)this.context).next(null, prefix, " ");
                }
                ((PrettyPrinter)this.context).appendName(iterator);
                ((PrettyPrinter)this.context).append(" : ");
                this.safeVisit(iterator.getType());
                prefix = ",";
            }
            ((PrettyPrinter)this.context).next(null, " |", " ");
            this.safeVisit(body != null ? body.getType() : null);
            ((PrettyPrinter)this.context).next("", ")", "");
            ((PrettyPrinter)this.context).pop();
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(object.getType());
        }
        return null;
    }

    public Object visitLetExp(@NonNull LetExp object) {
        ((PrettyPrinter)this.context).push("let", " ");
        this.safeVisit(object.getVariable());
        ((PrettyPrinter)this.context).exdent(" ", "in", " ");
        this.safeVisit(object.getIn());
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    public Object visitNullLiteralExp(@NonNull NullLiteralExp object) {
        ((PrettyPrinter)this.context).append("null");
        return null;
    }

    public Object visitOCLExpression(@NonNull OCLExpression object) {
        ((PrettyPrinter)this.context).append("<");
        ((PrettyPrinter)this.context).append(object.eClass().getName());
        ((PrettyPrinter)this.context).append(">");
        return null;
    }

    public Object visitOpaqueExpression(@NonNull OpaqueExpression object) {
        String body = PivotUtil.getBody(object);
        if (body != null) {
            ((PrettyPrinter)this.context).append(body);
        } else {
            ((PrettyPrinter)this.context).append("null -- not specified");
        }
        return null;
    }

    public Object visitOperationCallExp(@NonNull OperationCallExp object) {
        OCLExpression source = object.getSource();
        List<OCLExpression> arguments = object.getArgument();
        Operation referredOperation = object.getReferredOperation();
        if (((PrettyPrinter)this.context).showNames()) {
            Precedence precedence;
            Precedence precedence2 = precedence = referredOperation != null ? referredOperation.getPrecedence() : null;
            if (precedence == null) {
                this.appendSourceNavigation(object);
                if (!object.isImplicit()) {
                    ((PrettyPrinter)this.context).appendName(referredOperation);
                    ((PrettyPrinter)this.context).push("(", "");
                    String prefix = null;
                    for (OCLExpression argument : arguments) {
                        if (prefix != null) {
                            ((PrettyPrinter)this.context).next(null, prefix, " ");
                        }
                        ((PrettyPrinter)this.context).precedenceVisit(argument, null);
                        prefix = ",";
                    }
                    ((PrettyPrinter)this.context).next("", ")", "");
                    ((PrettyPrinter)this.context).pop();
                }
            } else {
                boolean lowerPrecedence;
                Precedence currentPrecedence = ((PrettyPrinter)this.context).getCurrentPrecedence();
                boolean bl = lowerPrecedence = currentPrecedence != null && precedence.getOrder().intValue() > currentPrecedence.getOrder().intValue();
                if (lowerPrecedence) {
                    ((PrettyPrinter)this.context).push("(", null);
                }
                if (arguments.size() == 0) {
                    ((PrettyPrinter)this.context).appendName(referredOperation, null);
                    if (referredOperation != null && PivotUtil.isValidIdentifier(referredOperation.getName())) {
                        ((PrettyPrinter)this.context).append(" ");
                    }
                    ((PrettyPrinter)this.context).precedenceVisit(source, precedence);
                } else {
                    ((PrettyPrinter)this.context).precedenceVisit(source, precedence);
                    String name = ((PrettyPrinter)this.context).getName(referredOperation, null);
                    assert (name != null);
                    ((PrettyPrinter)this.context).next(" ", name, " ");
                    ((PrettyPrinter)this.context).precedenceVisit(arguments.get(0), precedence);
                }
                if (lowerPrecedence) {
                    ((PrettyPrinter)this.context).exdent("", ")", "");
                    ((PrettyPrinter)this.context).pop();
                }
            }
        } else {
            Type sourceType;
            if (source != null && (sourceType = source.getType()) != null) {
                ((PrettyPrinter)this.context).appendQualifiedType(sourceType);
                ((PrettyPrinter)this.context).append("::");
            }
            ((PrettyPrinter)this.context).appendName(referredOperation);
            ((PrettyPrinter)this.context).push("(", "");
            String prefix = null;
            for (OCLExpression argument : arguments) {
                if (prefix != null) {
                    ((PrettyPrinter)this.context).next(null, prefix, " ");
                }
                this.safeVisit(argument.getType());
                prefix = ",";
            }
            ((PrettyPrinter)this.context).next("", ")", "");
            ((PrettyPrinter)this.context).pop();
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(object.getType());
        }
        return null;
    }

    public Object visitOppositePropertyCallExp(@NonNull OppositePropertyCallExp object) {
        Property referredProperty;
        Property referredOppositeProperty = object.getReferredProperty();
        Property property = referredProperty = referredOppositeProperty != null ? referredOppositeProperty.getOpposite() : null;
        if (((PrettyPrinter)this.context).showNames()) {
            this.appendSourceNavigation(object);
            ((PrettyPrinter)this.context).appendName(referredProperty);
        } else {
            Type sourceType;
            OCLExpression source = object.getSource();
            if (source != null && (sourceType = source.getType()) != null) {
                ((PrettyPrinter)this.context).appendQualifiedType(sourceType);
                ((PrettyPrinter)this.context).append("::");
            }
            ((PrettyPrinter)this.context).appendName(referredProperty);
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(object.getType());
        }
        return null;
    }

    public Object visitParameter(@NonNull Parameter object) {
        ((PrettyPrinter)this.context).appendName(object);
        Type type = object.getType();
        if (type != null) {
            ((PrettyPrinter)this.context).append(" : ");
            ((PrettyPrinter)this.context).appendQualifiedType(type);
        }
        return null;
    }

    public Object visitPropertyCallExp(@NonNull PropertyCallExp object) {
        Property referredProperty = object.getReferredProperty();
        if (((PrettyPrinter)this.context).showNames()) {
            this.appendSourceNavigation(object);
            ((PrettyPrinter)this.context).appendName(referredProperty);
        } else {
            Type sourceType;
            OCLExpression source = object.getSource();
            if (source != null && (sourceType = source.getType()) != null) {
                ((PrettyPrinter)this.context).appendQualifiedType(sourceType);
                ((PrettyPrinter)this.context).append("::");
            }
            ((PrettyPrinter)this.context).appendName(referredProperty);
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(object.getType());
        }
        return null;
    }

    public Object visitRealLiteralExp(@NonNull RealLiteralExp object) {
        ((PrettyPrinter)this.context).append(object.getRealSymbol());
        return null;
    }

    public Object visitStringLiteralExp(@NonNull StringLiteralExp object) {
        ((PrettyPrinter)this.context).append("'");
        ((PrettyPrinter)this.context).append(DomainUtil.convertToOCLString((String)object.getStringSymbol()));
        ((PrettyPrinter)this.context).append("'");
        return null;
    }

    public Object visitTupleLiteralExp(@NonNull TupleLiteralExp object) {
        ((PrettyPrinter)this.context).append("Tuple");
        ((PrettyPrinter)this.context).push("{", "");
        String prefix = "";
        for (TupleLiteralPart part : object.getPart()) {
            ((PrettyPrinter)this.context).append(prefix);
            this.safeVisit(part);
            prefix = ", ";
        }
        ((PrettyPrinter)this.context).exdent("", "}", "");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    public Object visitTupleLiteralPart(@NonNull TupleLiteralPart object) {
        ((PrettyPrinter)this.context).appendName(object);
        ((PrettyPrinter)this.context).append(" = ");
        this.safeVisit(object.getInitExpression());
        return null;
    }

    public Object visitTypeExp(@NonNull TypeExp object) {
        Type type = object.getReferredType();
        if (type != null) {
            ((PrettyPrinter)this.context).appendQualifiedType(type);
        }
        return null;
    }

    public Object visitUnlimitedNaturalLiteralExp(@NonNull UnlimitedNaturalLiteralExp object) {
        Number symbol = object.getUnlimitedNaturalSymbol();
        if (symbol == Unlimited.INSTANCE) {
            ((PrettyPrinter)this.context).append("*");
        } else {
            ((PrettyPrinter)this.context).append(symbol.toString());
        }
        return null;
    }

    public Object visitVariable(@NonNull Variable object) {
        OCLExpression initExpression;
        ((PrettyPrinter)this.context).appendName(object);
        Type type = object.getType();
        if (type != null) {
            ((PrettyPrinter)this.context).append(" : ");
            ((PrettyPrinter)this.context).appendQualifiedType(type);
        }
        if ((initExpression = object.getInitExpression()) != null) {
            ((PrettyPrinter)this.context).append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    public Object visitVariableExp(@NonNull VariableExp object) {
        VariableDeclaration referredVariable = object.getReferredVariable();
        if (referredVariable != null && "self".equals(referredVariable.getName())) {
            ((PrettyPrinter)this.context).appendName(referredVariable, null);
        } else {
            ((PrettyPrinter)this.context).appendName(referredVariable);
        }
        return null;
    }
}

