/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.manager.PackageManager;

class RootTracker
implements Adapter.Internal {
    protected final PackageManager packageManager;
    private final Root target;

    RootTracker(@NonNull PackageManager packageManager, @NonNull Root target) {
        this.packageManager = packageManager;
        this.target = target;
        target.eAdapters().add((Object)this);
    }

    void dispose() {
        this.packageManager.disposedRootTracker(this);
        this.target.eAdapters().remove((Object)this);
    }

    @NonNull
    public Root getTarget() {
        return this.target;
    }

    public boolean isAdapterForType(Object type) {
        return type == this.packageManager;
    }

    public void notifyChanged(Notification notification) {
        int eventType = notification.getEventType();
        Object feature = notification.getFeature();
        if (feature == PivotPackage.Literals.ROOT__NESTED_PACKAGE) {
            switch (eventType) {
                case 3: {
                    Object value = notification.getNewValue();
                    if (!(value instanceof Package)) break;
                    this.packageManager.addedMemberPackage((Package)value);
                    break;
                }
                case 5: {
                    List values = (List)notification.getNewValue();
                    for (Object value : values) {
                        if (!(value instanceof Package)) continue;
                        this.packageManager.addedMemberPackage((Package)value);
                    }
                    break;
                }
                case 4: {
                    Object value = notification.getOldValue();
                    if (!(value instanceof Package)) break;
                    this.packageManager.removedPackage((Package)value);
                    break;
                }
                case 6: {
                    List values = (List)notification.getOldValue();
                    for (Object value : values) {
                        if (!(value instanceof Package)) continue;
                        this.packageManager.removedPackage((Package)value);
                    }
                    break;
                }
            }
        }
    }

    public void setTarget(Notifier newTarget) {
        assert (this.target == newTarget);
    }

    public String toString() {
        return String.valueOf(this.target);
    }

    public void unsetTarget(Notifier oldTarget) {
        assert (this.target == oldTarget);
    }
}

