/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Library;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecedenceManager {
    private Map<String, List<Precedence>> nameToPrecedencesMap = null;
    private Map<String, String> infixToPrecedenceNameMap = null;
    private Map<String, String> prefixToPrecedenceNameMap = null;

    /*
     * WARNING - void declaration
     */
    @NonNull
    public List<String> compilePrecedences(@NonNull Iterable<? extends Library> libraries) {
        void var4_7;
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> orderedPrecedences = new ArrayList<String>();
        this.nameToPrecedencesMap = new HashMap<String, List<Precedence>>();
        this.infixToPrecedenceNameMap = new HashMap<String, String>();
        this.prefixToPrecedenceNameMap = new HashMap<String, String>();
        for (Library library : libraries) {
            List<Precedence> precedences = library.getOwnedPrecedence();
            if (precedences.size() <= 0) continue;
            this.compilePrecedencePackage(errors, library);
            int prevIndex = -1;
            List<Precedence> list = null;
            String name = null;
            for (Precedence precedence : precedences) {
                name = precedence.getName();
                int index = orderedPrecedences.indexOf(name);
                if (index < 0) {
                    index = prevIndex < 0 ? orderedPrecedences.size() : prevIndex + 1;
                    orderedPrecedences.add(index, name);
                    list = new ArrayList<Precedence>();
                    this.nameToPrecedencesMap.put(name, list);
                } else {
                    list = this.nameToPrecedencesMap.get(name);
                    if (index <= prevIndex) {
                        errors.add("Inconsistent precedence ordering for '" + name + "'");
                    } else if (prevIndex >= 0 && index != prevIndex + 1) {
                        errors.add("Ambiguous precedence ordering for '" + name + "'");
                    }
                    if (precedence.getAssociativity() != list.get(0).getAssociativity()) {
                        errors.add("Inconsistent precedence associativity for '" + name + "'");
                    }
                }
                prevIndex = index;
                list.add(precedence);
            }
            if (list == null || list.size() != 1 || prevIndex == orderedPrecedences.size() - 1) continue;
            errors.add("Ambiguous precedence ordering for '" + name + "' at tail");
        }
        boolean bl = false;
        while (var4_7 < orderedPrecedences.size()) {
            String name = (String)orderedPrecedences.get((int)var4_7);
            for (Precedence precedence : this.nameToPrecedencesMap.get(name)) {
                precedence.setOrder((int)var4_7);
            }
            ++var4_7;
        }
        return errors;
    }

    protected void compilePrecedenceOperation(@NonNull List<String> errors, @NonNull Operation operation) {
        Precedence precedence = operation.getPrecedence();
        if (precedence != null) {
            List<Parameter> parameters = operation.getOwnedParameter();
            if (parameters.size() == 0) {
                String newName = precedence.getName();
                String operatorName = operation.getName();
                String oldName = this.prefixToPrecedenceNameMap.put(operatorName, newName);
                if (oldName != null && !oldName.equals(newName)) {
                    errors.add("Conflicting precedences for prefix operation '" + operatorName + "'");
                }
            } else if (parameters.size() == 1) {
                String newName = precedence.getName();
                String operatorName = operation.getName();
                String oldName = this.infixToPrecedenceNameMap.put(operatorName, newName);
                if (oldName != null && !oldName.equals(newName)) {
                    errors.add("Conflicting precedences for infix operation '" + operatorName + "'");
                }
            }
        }
    }

    protected void compilePrecedencePackage(@NonNull List<String> errors, @NonNull Library library) {
        for (Type type : library.getOwnedType()) {
            if (type == null || !PivotUtil.isLibraryType(type)) continue;
            this.compilePrecedenceType(errors, type);
        }
    }

    protected void compilePrecedenceType(@NonNull List<String> errors, @NonNull Type pivotType) {
        for (Operation operation : pivotType.getOwnedOperation()) {
            if (operation == null) continue;
            this.compilePrecedenceOperation(errors, operation);
        }
    }

    public void dispose() {
        this.nameToPrecedencesMap = null;
        this.infixToPrecedenceNameMap = null;
        this.prefixToPrecedenceNameMap = null;
    }

    @Nullable
    public Precedence getInfixPrecedence(@NonNull String operatorName) {
        String precedenceName = this.infixToPrecedenceNameMap.get(operatorName);
        if (precedenceName == null) {
            return null;
        }
        List<Precedence> precedences = this.nameToPrecedencesMap.get(precedenceName);
        if (precedences == null) {
            return null;
        }
        return precedences.get(0);
    }

    @Nullable
    public Precedence getPrefixPrecedence(@NonNull String operatorName) {
        String precedenceName = this.prefixToPrecedenceNameMap.get(operatorName);
        if (precedenceName == null) {
            return null;
        }
        List<Precedence> precedences = this.nameToPrecedencesMap.get(precedenceName);
        if (precedences == null) {
            return null;
        }
        return precedences.get(0);
    }
}

