/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.types.AbstractStandardLibrary;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.oclany.OclAnyUnsupportedOperation;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.BagType;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OrderedSetType;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.SelfType;
import org.eclipse.ocl.examples.pivot.SequenceType;
import org.eclipse.ocl.examples.pivot.SetType;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PivotStandardLibrary
extends AbstractStandardLibrary {
    private static final Logger logger = Logger.getLogger(PivotStandardLibrary.class);
    @NonNull
    public static final String DEFAULT_OCL_STDLIB_URI = "http://www.eclipse.org/ocl/3.1.0/OCL.oclstdlib";
    @NonNull
    protected String defaultStandardLibraryURI = "http://www.eclipse.org/ocl/3.1.0/OCL.oclstdlib";
    @Nullable
    private BagType bagType = null;
    @Nullable
    private PrimitiveType booleanType = null;
    @Nullable
    private Class classType = null;
    @Nullable
    private CollectionType collectionType = null;
    @Nullable
    private Class enumerationType = null;
    @Nullable
    private PrimitiveType integerType = null;
    @Nullable
    private Metaclass<?> metaclassType = null;
    @Nullable
    private AnyType oclAnyType = null;
    @Nullable
    private Class oclComparableType = null;
    @Nullable
    private Class oclElementType = null;
    @Nullable
    private Operation oclInvalidOperation = null;
    @Nullable
    private Property oclInvalidProperty = null;
    @Nullable
    private InvalidType oclInvalidType = null;
    @Nullable
    private Class oclLambdaType = null;
    @Nullable
    private SelfType oclSelfType = null;
    @Nullable
    private Class oclSummableType = null;
    @Nullable
    private Class oclTupleType = null;
    @Nullable
    private Class oclTypeType = null;
    @Nullable
    private VoidType oclVoidType = null;
    @Nullable
    private CollectionType orderedCollectionType = null;
    @Nullable
    private OrderedSetType orderedSetType = null;
    @Nullable
    private PrimitiveType realType = null;
    @Nullable
    private SequenceType sequenceType = null;
    @Nullable
    private SetType setType = null;
    @Nullable
    private PrimitiveType stringType = null;
    @Nullable
    private CollectionType uniqueCollectionType = null;
    @Nullable
    private PrimitiveType unlimitedNaturalType = null;
    @Nullable
    private Map<String, Type> nameToLibraryTypeMap = null;

    protected void defineLibraryType(@NonNull Type pivotType) {
        String name;
        Type oldType;
        Map<String, Type> nameToLibraryTypeMap2 = this.nameToLibraryTypeMap;
        if (nameToLibraryTypeMap2 == null) {
            this.nameToLibraryTypeMap = nameToLibraryTypeMap2 = new HashMap<String, Type>();
        }
        if ((oldType = nameToLibraryTypeMap2.put(name = pivotType.getName(), pivotType)) != null && oldType != pivotType) {
            logger.warn((Object)("Conflicting pivot type '" + name + "'"));
        }
    }

    @Nullable
    public Operation basicGetOclInvalidOperation() {
        return this.oclInvalidOperation;
    }

    @Nullable
    public Property basicGetOclInvalidProperty() {
        return this.oclInvalidProperty;
    }

    @Nullable
    public InvalidType basicGetOclInvalidType() {
        return this.oclInvalidType;
    }

    public void dispose() {
        this.resetLibrary();
        super.dispose();
    }

    @NonNull
    public BagType getBagType() {
        BagType bagType2 = this.bagType;
        if (bagType2 == null) {
            bagType2 = this.bagType = this.resolveRequiredTemplateableType(BagType.class, "Bag", 1);
        }
        return bagType2;
    }

    @NonNull
    public PrimitiveType getBooleanType() {
        PrimitiveType booleanType2 = this.booleanType;
        if (booleanType2 == null) {
            booleanType2 = this.booleanType = this.resolveRequiredSimpleType(PrimitiveType.class, "Boolean");
        }
        return booleanType2;
    }

    @NonNull
    public Class getClassType() {
        Class classType2 = this.classType;
        if (classType2 == null) {
            classType2 = this.classType = this.resolveRequiredSimpleType(Class.class, "Class");
        }
        return classType2;
    }

    @NonNull
    public CollectionType getCollectionType() {
        CollectionType collectionType2 = this.collectionType;
        if (collectionType2 == null) {
            collectionType2 = this.collectionType = this.resolveRequiredTemplateableType(CollectionType.class, "Collection", 1);
        }
        return collectionType2;
    }

    @NonNull
    public Class getEnumerationType() {
        Class enumerationType2 = this.enumerationType;
        if (enumerationType2 == null) {
            enumerationType2 = this.enumerationType = this.resolveRequiredSimpleType(Class.class, "Enumeration");
        }
        return enumerationType2;
    }

    @NonNull
    public PrimitiveType getIntegerType() {
        PrimitiveType integerType2 = this.integerType;
        if (integerType2 == null) {
            integerType2 = this.integerType = this.resolveRequiredSimpleType(PrimitiveType.class, "Integer");
        }
        return integerType2;
    }

    public Type getLibraryType(@NonNull String typeName) {
        Map<String, Type> nameToLibraryTypeMap2 = this.nameToLibraryTypeMap;
        if (nameToLibraryTypeMap2 == null) {
            this.nameToLibraryTypeMap = nameToLibraryTypeMap2 = new HashMap<String, Type>();
            this.loadDefaultLibrary(this.defaultStandardLibraryURI);
        }
        return nameToLibraryTypeMap2.get(typeName);
    }

    @NonNull
    public Metaclass<?> getMetaclassType() {
        Metaclass metaclassType2 = this.metaclassType;
        if (metaclassType2 == null) {
            metaclassType2 = this.metaclassType = this.resolveRequiredTemplateableType(Metaclass.class, "Metaclass", 1);
        }
        return metaclassType2;
    }

    @NonNull
    public AnyType getOclAnyType() {
        AnyType oclAnyType2 = this.oclAnyType;
        if (oclAnyType2 == null) {
            oclAnyType2 = this.oclAnyType = this.resolveRequiredSimpleType(AnyType.class, "OclAny");
        }
        return oclAnyType2;
    }

    @NonNull
    public Class getOclComparableType() {
        Class oclComparableType2 = this.oclComparableType;
        if (oclComparableType2 == null) {
            oclComparableType2 = this.oclComparableType = this.resolveRequiredSimpleType(Class.class, "OclComparable");
        }
        return oclComparableType2;
    }

    @NonNull
    public Class getOclElementType() {
        Class oclElementType2 = this.oclElementType;
        if (oclElementType2 == null) {
            oclElementType2 = this.oclElementType = this.resolveRequiredSimpleType(Class.class, "OclElement");
        }
        return oclElementType2;
    }

    @NonNull
    public Operation getOclInvalidOperation() {
        Operation oclInvalidOperation2 = this.oclInvalidOperation;
        if (oclInvalidOperation2 == null) {
            String invalidName;
            InvalidType invalidType = this.getOclInvalidType();
            List<Operation> invalidOperations = invalidType.getOwnedOperation();
            oclInvalidOperation2 = (Operation)DomainUtil.getNamedElement(invalidOperations, (String)(invalidName = "oclBadOperation"));
            if (oclInvalidOperation2 == null) {
                oclInvalidOperation2 = PivotFactory.eINSTANCE.createOperation();
                oclInvalidOperation2.setName(invalidName);
                oclInvalidOperation2.setType(invalidType);
                oclInvalidOperation2.setImplementation((LibraryFeature)OclAnyUnsupportedOperation.INSTANCE);
                invalidOperations.add(oclInvalidOperation2);
            }
            this.oclInvalidOperation = oclInvalidOperation2;
        }
        return oclInvalidOperation2;
    }

    @NonNull
    public Property getOclInvalidProperty() {
        Property oclInvalidProperty2 = this.oclInvalidProperty;
        if (oclInvalidProperty2 == null) {
            String invalidName;
            InvalidType invalidType = this.getOclInvalidType();
            List<Property> invalidProperties = invalidType.getOwnedAttribute();
            oclInvalidProperty2 = (Property)DomainUtil.getNamedElement(invalidProperties, (String)(invalidName = "oclBadProperty"));
            if (oclInvalidProperty2 == null) {
                oclInvalidProperty2 = PivotFactory.eINSTANCE.createProperty();
                oclInvalidProperty2.setName(invalidName);
                oclInvalidProperty2.setType(invalidType);
                oclInvalidProperty2.setImplementation((LibraryFeature)OclAnyUnsupportedOperation.INSTANCE);
                invalidProperties.add(oclInvalidProperty2);
            }
            this.oclInvalidProperty = oclInvalidProperty2;
        }
        return oclInvalidProperty2;
    }

    @NonNull
    public InvalidType getOclInvalidType() {
        InvalidType oclInvalidType2 = this.oclInvalidType;
        if (oclInvalidType2 == null) {
            oclInvalidType2 = this.oclInvalidType = this.resolveRequiredSimpleType(InvalidType.class, "OclInvalid");
        }
        return oclInvalidType2;
    }

    @NonNull
    public Class getOclLambdaType() {
        Class oclLambdaType2 = this.oclLambdaType;
        if (oclLambdaType2 == null) {
            oclLambdaType2 = this.oclLambdaType = this.resolveRequiredSimpleType(Class.class, "OclLambda");
        }
        return oclLambdaType2;
    }

    public Type getOclMessageType() {
        return this.getRequiredLibraryType("OclMessage");
    }

    @NonNull
    public SelfType getOclSelfType() {
        SelfType oclSelfType2 = this.oclSelfType;
        if (oclSelfType2 == null) {
            oclSelfType2 = this.oclSelfType = this.resolveRequiredSimpleType(SelfType.class, "OclSelf");
        }
        return oclSelfType2;
    }

    @NonNull
    public Class getOclSummableType() {
        Class oclSummableType2 = this.oclSummableType;
        if (oclSummableType2 == null) {
            oclSummableType2 = this.oclSummableType = this.resolveRequiredSimpleType(Class.class, "OclSummable");
        }
        return oclSummableType2;
    }

    @NonNull
    public Class getOclTupleType() {
        Class oclTupleType2 = this.oclTupleType;
        if (oclTupleType2 == null) {
            oclTupleType2 = this.oclTupleType = this.resolveRequiredSimpleType(Class.class, "OclTuple");
        }
        return oclTupleType2;
    }

    @NonNull
    public Class getOclTypeType() {
        Class oclTypeType2 = this.oclTypeType;
        if (oclTypeType2 == null) {
            oclTypeType2 = this.oclTypeType = this.resolveRequiredSimpleType(Class.class, "OclType");
        }
        return oclTypeType2;
    }

    @NonNull
    public VoidType getOclVoidType() {
        VoidType oclVoidType2 = this.oclVoidType;
        if (oclVoidType2 == null) {
            oclVoidType2 = this.oclVoidType = this.resolveRequiredSimpleType(VoidType.class, "OclVoid");
        }
        return oclVoidType2;
    }

    @NonNull
    public CollectionType getOrderedCollectionType() {
        CollectionType orderedCollectionType2 = this.orderedCollectionType;
        if (orderedCollectionType2 == null) {
            orderedCollectionType2 = this.orderedCollectionType = this.resolveRequiredTemplateableType(CollectionType.class, "OrderedCollection", 1);
        }
        return orderedCollectionType2;
    }

    @NonNull
    public OrderedSetType getOrderedSetType() {
        OrderedSetType orderedSetType2 = this.orderedSetType;
        if (orderedSetType2 == null) {
            orderedSetType2 = this.orderedSetType = this.resolveRequiredTemplateableType(OrderedSetType.class, "OrderedSet", 1);
        }
        return orderedSetType2;
    }

    @NonNull
    public PrimitiveType getRealType() {
        PrimitiveType realType2 = this.realType;
        if (realType2 == null) {
            realType2 = this.realType = this.resolveRequiredSimpleType(PrimitiveType.class, "Real");
        }
        return realType2;
    }

    @NonNull
    public Type getRequiredLibraryType(@NonNull String typeName) {
        Type type = this.getLibraryType(typeName);
        if (type == null) {
            type = this.getLibraryType(typeName);
            Map<String, Type> nameToLibraryTypeMap2 = this.nameToLibraryTypeMap;
            if (nameToLibraryTypeMap2 == null || nameToLibraryTypeMap2.isEmpty()) {
                throw new IllegalLibraryException(OCLMessages.EmptyLibrary_ERROR_);
            }
            throw new IllegalLibraryException(NLS.bind((String)OCLMessages.MissingLibraryType_ERROR_, (Object)typeName));
        }
        return type;
    }

    @NonNull
    public SequenceType getSequenceType() {
        SequenceType sequenceType2 = this.sequenceType;
        if (sequenceType2 == null) {
            sequenceType2 = this.sequenceType = this.resolveRequiredTemplateableType(SequenceType.class, "Sequence", 1);
        }
        return sequenceType2;
    }

    @NonNull
    public SetType getSetType() {
        SetType setType2 = this.setType;
        if (setType2 == null) {
            setType2 = this.setType = this.resolveRequiredTemplateableType(SetType.class, "Set", 1);
        }
        return setType2;
    }

    @NonNull
    public PrimitiveType getStringType() {
        PrimitiveType stringType2 = this.stringType;
        if (stringType2 == null) {
            stringType2 = this.stringType = this.resolveRequiredSimpleType(PrimitiveType.class, "String");
        }
        return stringType2;
    }

    @NonNull
    public CollectionType getUniqueCollectionType() {
        CollectionType uniqueCollectionType2 = this.uniqueCollectionType;
        if (uniqueCollectionType2 == null) {
            uniqueCollectionType2 = this.uniqueCollectionType = this.resolveRequiredTemplateableType(CollectionType.class, "UniqueCollection", 1);
        }
        return uniqueCollectionType2;
    }

    @NonNull
    public PrimitiveType getUnlimitedNaturalType() {
        PrimitiveType unlimitedNaturalType2 = this.unlimitedNaturalType;
        if (unlimitedNaturalType2 == null) {
            unlimitedNaturalType2 = this.unlimitedNaturalType = this.resolveRequiredSimpleType(PrimitiveType.class, "UnlimitedNatural");
        }
        return unlimitedNaturalType2;
    }

    public boolean isOrdered(Type sourceType) {
        if (sourceType instanceof OrderedSetType) {
            return true;
        }
        return sourceType instanceof SequenceType;
    }

    public boolean isUnique(Type sourceType) {
        if (sourceType instanceof OrderedSetType) {
            return true;
        }
        return sourceType instanceof SetType;
    }

    protected abstract Resource loadDefaultLibrary(String var1);

    public void resetLibrary() {
        this.bagType = null;
        this.booleanType = null;
        this.classType = null;
        this.collectionType = null;
        this.enumerationType = null;
        this.integerType = null;
        this.metaclassType = null;
        this.oclAnyType = null;
        this.oclElementType = null;
        this.oclInvalidType = null;
        this.oclLambdaType = null;
        this.oclTupleType = null;
        this.oclTypeType = null;
        this.oclVoidType = null;
        this.orderedSetType = null;
        this.realType = null;
        this.sequenceType = null;
        this.setType = null;
        this.stringType = null;
        this.unlimitedNaturalType = null;
        this.nameToLibraryTypeMap = null;
    }

    @NonNull
    protected <T extends TemplateableElement> T resolveRequiredSimpleType(@NonNull java.lang.Class<T> requiredClassType, @NonNull String name) {
        Type type = this.getRequiredLibraryType(name);
        if (requiredClassType.isAssignableFrom(type.getClass())) {
            Type type2 = type;
            return (T)type2;
        }
        throw new IllegalLibraryException(String.valueOf(name) + " is not a " + requiredClassType.getSimpleName());
    }

    @NonNull
    protected <T extends TemplateableElement> T resolveRequiredTemplateableType(@NonNull java.lang.Class<T> requiredClassType, @NonNull String name, int parameterCount) {
        Type type = this.getRequiredLibraryType(name);
        if (requiredClassType.isAssignableFrom(type.getClass())) {
            if (type.getOwnedTemplateSignature() == null) {
                throw new IllegalLibraryException(String.valueOf(name) + " is not a templated type");
            }
            if (type.getOwnedTemplateSignature().getOwnedParameter().size() != parameterCount) {
                throw new IllegalLibraryException(String.valueOf(name) + " is not a templated type with " + parameterCount + " argument" + (parameterCount != 1 ? "s" : ""));
            }
            Type type2 = type;
            return (T)type2;
        }
        throw new IllegalLibraryException(String.valueOf(name) + " is not a " + requiredClassType.getSimpleName());
    }
}

