/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.ids.PackageId;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;

public class NestedPackageServer
extends PackageServer {
    @NonNull
    public static final List<NestedPackageServer> EMPTY_LIST = Collections.emptyList();
    @NonNull
    private final PackageServer parentPackageServer;

    public NestedPackageServer(@NonNull PackageServer parentPackageServer, @NonNull String name, @Nullable String nsPrefix, @Nullable String nsURI, @NonNull PackageId packageId) {
        super(parentPackageServer.getPackageManager(), name, nsPrefix, nsURI, packageId);
        this.parentPackageServer = parentPackageServer;
    }

    protected void assertSamePackage(@Nullable DomainPackage domainPackage) {
        assert (domainPackage != null);
        DomainPackage parentPackage = domainPackage.getNestingPackage();
        assert (parentPackage != null);
        this.parentPackageServer.assertSamePackage(parentPackage);
        super.assertSamePackage(domainPackage);
    }

    public void dispose() {
        super.dispose();
        this.parentPackageServer.disposedNestedPackageServer(this);
    }

    @NonNull
    public DomainPackage getNestingPackage() {
        return this.parentPackageServer;
    }

    @NonNull
    public PackageServer getParentPackageServer() {
        return this.parentPackageServer;
    }
}

