/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.ParametersId;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PackageManager;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;

public class FinalAnalysis {
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    private final Map<DomainInheritance, Set<DomainInheritance>> type2subTypes = new HashMap<DomainInheritance, Set<DomainInheritance>>();
    @NonNull
    private final Map<DomainOperation, Set<DomainOperation>> operation2overrides = new HashMap<DomainOperation, Set<DomainOperation>>();

    public FinalAnalysis(@NonNull PackageManager packageManager) {
        this.metaModelManager = packageManager.getMetaModelManager();
        for (PackageServer packageServer : packageManager.getAllPackages()) {
            for (TypeServer typeServer : packageServer.getMemberTypes()) {
                Type subType = typeServer.getPivotType();
                DomainInheritance subInheritance = subType.getInheritance((DomainStandardLibrary)this.metaModelManager);
                for (DomainInheritance domainInheritance : typeServer.getAllSuperClasses()) {
                    Set<DomainInheritance> subInheritances = this.type2subTypes.get(domainInheritance);
                    if (subInheritances == null) {
                        subInheritances = new HashSet<DomainInheritance>();
                        this.type2subTypes.put(domainInheritance, subInheritances);
                    }
                    subInheritances.add(subInheritance);
                }
            }
        }
        for (DomainInheritance domainInheritance : this.type2subTypes.keySet()) {
            Set<DomainInheritance> subInheritances = this.type2subTypes.get(domainInheritance);
            for (DomainOperation domainOperation : domainInheritance.getLocalOperations()) {
                String opName = domainOperation.getName();
                ParametersId parametersId = domainOperation.getParametersId();
                LibraryFeature domainImplementation = domainOperation.getImplementation();
                HashSet<DomainOperation> overrides = null;
                for (DomainInheritance subInheritance : subInheritances) {
                    if (subInheritance == domainInheritance) continue;
                    for (DomainOperation subOperation : subInheritance.getLocalOperations()) {
                        LibraryFeature subImplementation;
                        if (!opName.equals(subOperation.getName()) || !parametersId.equals(subOperation.getParametersId()) || domainImplementation == (subImplementation = subOperation.getImplementation())) continue;
                        if (overrides == null) {
                            overrides = new HashSet<DomainOperation>();
                            overrides.add(domainOperation);
                        }
                        overrides.add(subOperation);
                    }
                }
                this.operation2overrides.put(domainOperation, overrides);
            }
        }
    }

    public boolean isFinal(@NonNull DomainInheritance domainInheritance) {
        Set<DomainInheritance> subInheritances = this.type2subTypes.get(domainInheritance);
        return subInheritances.size() <= 1;
    }

    public boolean isFinal(@NonNull DomainOperation operation) {
        Set<DomainOperation> overrides = this.operation2overrides.get(operation);
        return overrides == null;
    }

    @Nullable
    public DomainOperation isFinal(@NonNull DomainOperation operation, @NonNull DomainInheritance domainInheritance) {
        Set<DomainOperation> overrides = this.operation2overrides.get(operation);
        if (overrides == null) {
            return operation;
        }
        DomainOperation candidate = null;
        for (DomainOperation override : overrides) {
            DomainInheritance overrideInheritance = override.getInheritance((DomainStandardLibrary)this.metaModelManager);
            if (overrideInheritance == null || !overrideInheritance.conformsTo((DomainStandardLibrary)this.metaModelManager, (DomainType)domainInheritance)) continue;
            if (candidate != null) {
                return null;
            }
            candidate = override;
        }
        return candidate;
    }

    public void print(@NonNull StringBuilder s) {
        ArrayList<DomainInheritance> allInheritances = new ArrayList<DomainInheritance>(this.type2subTypes.keySet());
        Collections.sort(allInheritances, new Comparator<DomainInheritance>(){

            @Override
            public int compare(DomainInheritance o1, DomainInheritance o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        s.append("Final types");
        for (DomainInheritance anInheritance : allInheritances) {
            assert (anInheritance != null);
            if (!this.isFinal(anInheritance)) continue;
            s.append("\n\t");
            s.append(anInheritance.getName());
        }
        s.append("\nNon-final types");
        for (DomainInheritance anInheritance : allInheritances) {
            assert (anInheritance != null);
            if (this.isFinal(anInheritance)) continue;
            s.append("\n\t");
            s.append(anInheritance.getName());
        }
    }
}

