/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.AbstractTypeServer;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;
import org.eclipse.ocl.examples.pivot.manager.TypeTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtensibleTypeServer
extends AbstractTypeServer {
    @NonNull
    private final List<TypeTracker> trackers = new ArrayList<TypeTracker>();
    @Nullable
    private Type representativeType = null;

    protected ExtensibleTypeServer(@NonNull PackageServer packageServer, @NonNull DomainType domainType) {
        super(packageServer, domainType);
        if (!(domainType instanceof PrimitiveType)) {
            packageServer.assertSamePackage(domainType.getPackage());
        }
    }

    @Override
    public void dispose() {
        if (!this.trackers.isEmpty()) {
            ArrayList<TypeTracker> savedTypeTrackers = new ArrayList<TypeTracker>(this.trackers);
            this.trackers.clear();
            for (TypeTracker typeTracker : savedTypeTrackers) {
                typeTracker.dispose();
            }
        }
        super.dispose();
        this.packageServer.disposedTypeServer(this);
    }

    void disposedTypeTracker(@NonNull TypeTracker typeTracker) {
        this.trackers.remove(typeTracker);
        this.representativeType = null;
        this.uninstall();
        if (this.trackers.size() <= 0) {
            this.dispose();
        }
        this.packageManager.disposedTypeTracker(typeTracker);
    }

    @Nullable
    Type findPivotType() {
        for (TypeTracker typeTracker : this.trackers) {
            DomainType trackedType = typeTracker.getType();
            if (!(trackedType instanceof Type)) continue;
            return (Type)trackedType;
        }
        return null;
    }

    @NonNull
    public Iterable<DomainType> getPartialTypes() {
        Iterable transform = Iterables.transform(this.trackers, TypeTracker.tracker2type);
        return transform;
    }

    @Override
    @NonNull
    public Type getPivotType() {
        Type representativeType2 = this.representativeType;
        if (representativeType2 == null && (representativeType2 = (this.representativeType = this.findPivotType())) == null) {
            throw new IllegalStateException("Missing pivot type");
        }
        return representativeType2;
    }

    @NonNull
    public TypeTracker getTypeTracker(@NonNull DomainType pivotType) {
        TypeTracker typeTracker2;
        for (TypeTracker typeTracker2 : this.trackers) {
            if (typeTracker2.getTarget() != pivotType) continue;
            return typeTracker2;
        }
        typeTracker2 = new TypeTracker(this, pivotType);
        this.initMemberFeaturesFrom(pivotType);
        this.trackers.add(typeTracker2);
        this.packageManager.addTypeTracker(pivotType, typeTracker2);
        return typeTracker2;
    }

    @NonNull
    public List<TypeTracker> getTypeTrackers() {
        return this.trackers;
    }

    public String toString() {
        if (this.trackers.size() > 0) {
            return String.valueOf(this.trackers.get(0).getType());
        }
        return "<<null>>";
    }

    @Override
    public void uninstall() {
        this.representativeType = null;
        super.uninstall();
    }
}

