/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.library.executor.CollectionTypeParameters;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.ExtensibleTypeServer;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.Orphanage;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionTypeServer
extends ExtensibleTypeServer {
    private static final Logger logger = Logger.getLogger(CollectionTypeServer.class);
    @Nullable
    private Map<CollectionTypeParameters<Type>, WeakReference<Type>> specializations = null;

    protected CollectionTypeServer(@NonNull PackageServer packageServer, @NonNull DomainCollectionType domainType) {
        super(packageServer, (DomainType)domainType);
    }

    @NonNull
    protected Type createSpecialization(@NonNull CollectionTypeParameters<Type> typeParameters) {
        Type unspecializedType = this.getPivotType();
        String typeName = unspecializedType.getName();
        TemplateSignature templateSignature = unspecializedType.getOwnedTemplateSignature();
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameter();
        EClass eClass = unspecializedType.eClass();
        EFactory eFactoryInstance = eClass.getEPackage().getEFactoryInstance();
        CollectionType specializedType = (CollectionType)eFactoryInstance.create(eClass);
        specializedType.setName(typeName);
        TemplateBinding templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
        templateBinding.setSignature(templateSignature);
        HashMap<TemplateParameter, ParameterableElement> allBindings = new HashMap<TemplateParameter, ParameterableElement>();
        TemplateParameter formalParameter = templateParameters.get(0);
        assert (formalParameter != null);
        Type elementType = (Type)typeParameters.getElementType();
        allBindings.put(formalParameter, elementType);
        TemplateParameterSubstitution templateParameterSubstitution = CollectionTypeServer.createTemplateParameterSubstitution(formalParameter, elementType);
        templateBinding.getParameterSubstitution().add(templateParameterSubstitution);
        specializedType.getTemplateBinding().add(templateBinding);
        this.packageManager.resolveSuperClasses(specializedType, unspecializedType, allBindings);
        CollectionType specializedCollectionType = specializedType;
        specializedCollectionType.setElementType((Type)typeParameters.getElementType());
        try {
            specializedCollectionType.setLowerValue(typeParameters.getLower());
        }
        catch (InvalidValueException e) {
            logger.error((Object)"Out of range lower bound", (Throwable)e);
        }
        try {
            specializedCollectionType.setUpperValue(typeParameters.getUpper());
        }
        catch (InvalidValueException e) {
            logger.error((Object)"Out of range upper bound", (Throwable)e);
        }
        specializedType.setUnspecializedElement(unspecializedType);
        MetaModelManager metaModelManager = this.packageManager.getMetaModelManager();
        Orphanage orphanage = Orphanage.getOrphanage(metaModelManager.getASResourceSet());
        specializedType.setPackage(orphanage);
        return specializedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public synchronized Type findSpecializedType(@NonNull CollectionTypeParameters<Type> typeParameters) {
        TemplateSignature templateSignature = this.getPivotType().getOwnedTemplateSignature();
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameter();
        if (templateParameters.size() != 1) {
            return null;
        }
        Map<CollectionTypeParameters<Type>, WeakReference<Type>> specializations2 = this.specializations;
        if (specializations2 == null) {
            return null;
        }
        WeakReference<Type> weakReference = specializations2.get(typeParameters);
        if (weakReference == null) {
            return null;
        }
        Type type = (Type)weakReference.get();
        if (type == null) {
            Map<CollectionTypeParameters<Type>, WeakReference<Type>> map = specializations2;
            synchronized (map) {
                type = (Type)weakReference.get();
                if (type == null) {
                    specializations2.remove(typeParameters);
                }
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public synchronized Type getSpecializedType(@NonNull Type elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        Object object;
        assert (this.getPivotType() instanceof CollectionType);
        IntegerValue lower2 = lower;
        IntegerValue upper2 = upper;
        if (lower2 == null) {
            lower2 = ValuesUtil.ZERO_VALUE;
        }
        if (upper2 == null) {
            upper2 = ValuesUtil.UNLIMITED_VALUE;
        }
        CollectionTypeParameters typeParameters = new CollectionTypeParameters((DomainType)elementType, lower2, upper2);
        Map<CollectionTypeParameters<Type>, WeakReference<Type>> specializations2 = this.specializations;
        if (specializations2 == null) {
            object = this;
            synchronized (object) {
                specializations2 = this.specializations;
                if (specializations2 == null) {
                    specializations2 = this.specializations = new HashMap<CollectionTypeParameters<Type>, WeakReference<Type>>();
                }
            }
        }
        object = specializations2;
        synchronized (object) {
            Type specializedType = null;
            WeakReference<Type> weakReference = specializations2.get(typeParameters);
            if (weakReference != null) {
                specializedType = (Type)weakReference.get();
            }
            if (specializedType == null) {
                specializedType = this.createSpecialization((CollectionTypeParameters<Type>)typeParameters);
                specializations2.put((CollectionTypeParameters<Type>)typeParameters, new WeakReference<Type>(specializedType));
            }
            return specializedType;
        }
    }
}

