/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractProperty;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ElementExtension;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Stereotype;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.uml.UMLElementExtension;

public class ExtensionProperty
extends AbstractProperty {
    @NonNull
    protected Property property;

    public ExtensionProperty(@NonNull Property property) {
        this.property = property;
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        Type staticType = this.property.getType();
        if (sourceValue instanceof org.eclipse.uml2.uml.Element && staticType instanceof Stereotype) {
            return UMLElementExtension.getUMLElementExtension((Stereotype)staticType, (org.eclipse.uml2.uml.Element)sourceValue);
        }
        Element element = null;
        if (sourceValue instanceof Element) {
            element = (Element)sourceValue;
        } else {
            try {
                element = ((MetaModelManager)evaluator.getStandardLibrary()).getPivotOf(Element.class, (EObject)sourceValue);
            }
            catch (ParserException e) {
                return new InvalidValueException((Exception)e, "Failed to parse " + this.property);
            }
        }
        if (element != null) {
            ArrayList<ElementExtension> selectedExtensions = null;
            for (ElementExtension elementExtension : element.getExtension()) {
                Stereotype dynamicStereotype = elementExtension.getStereotype();
                if (!dynamicStereotype.conformsTo(evaluator.getStandardLibrary(), staticType)) continue;
                if (selectedExtensions == null) {
                    selectedExtensions = new ArrayList<ElementExtension>();
                }
                selectedExtensions.add(elementExtension);
            }
            if (selectedExtensions == null) {
                return null;
            }
            TypeId typeId = this.property.getTypeId();
            if (typeId instanceof CollectionTypeId) {
                return ValuesUtil.createSetValue((CollectionTypeId)((CollectionTypeId)typeId), (Collection)selectedExtensions);
            }
            if (selectedExtensions.size() == 1) {
                return selectedExtensions.get(0);
            }
            return new InvalidValueException("Multiple applied stereotypes for " + this.property, new Object[0]);
        }
        return staticType;
    }
}

