/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractProperty;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitorImpl;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class ConstrainedProperty
extends AbstractProperty {
    @NonNull
    protected final Property property;
    protected ExpressionInOCL expression = null;

    public ConstrainedProperty(@NonNull Property property) {
        this.property = property;
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        ExpressionInOCL expression2 = this.expression;
        if (expression2 == null) {
            OpaqueExpression defaultExpression = this.property.getDefaultExpression();
            if (defaultExpression == null) {
                throw new InvalidValueException("No defaultExpression for '{0}'", new Object[]{this.property});
            }
            this.expression = expression2 = defaultExpression.getExpressionInOCL();
            if (expression2 == null) {
                throw new InvalidValueException("Bad defaultExpression for '{0}'", new Object[]{this.property});
            }
        }
        PivotUtil.checkExpression(expression2);
        EvaluationVisitor evaluationVisitor = (EvaluationVisitor)evaluator;
        EvaluationVisitor nestedVisitor = evaluationVisitor instanceof EvaluationVisitorImpl ? ((EvaluationVisitorImpl)evaluationVisitor).createNestedUndecoratedEvaluator(expression2) : evaluationVisitor.createNestedEvaluator();
        EvaluationEnvironment nestedEvaluationEnvironment = nestedVisitor.getEvaluationEnvironment();
        Variable contextVariable = expression2.getContextVariable();
        if (contextVariable != null) {
            nestedEvaluationEnvironment.add(contextVariable, sourceValue);
        }
        try {
            Object object = nestedVisitor.evaluate(expression2);
            return object;
        }
        finally {
            nestedVisitor.dispose();
        }
    }
}

