/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.PropertyId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractProperty;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;

public class CompositionProperty
extends AbstractProperty {
    @NonNull
    protected final EReference eContainmentFeature;
    @NonNull
    protected final PropertyId propertyId;

    public CompositionProperty(@NonNull EReference eContainmentFeature, @NonNull PropertyId propertyId) {
        this.eContainmentFeature = eContainmentFeature;
        this.propertyId = propertyId;
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        EObject eObject = CompositionProperty.asNavigableObject((Object)sourceValue, (Object)this.eContainmentFeature);
        EObject eContainer = eObject.eContainer();
        if (eContainer == null) {
            return null;
        }
        EReference eContainmentFeature = (EReference)DomainUtil.nonNullModel((Object)eObject.eContainmentFeature());
        if (eContainmentFeature != this.eContainmentFeature && !this.isReferenced(eContainmentFeature)) {
            return null;
        }
        return evaluator.getIdResolver().boxedValueOf((Object)eContainer);
    }

    protected boolean isReferenced(EReference eObject) {
        EAnnotation eAnnotation = eObject.getEAnnotation("subsets");
        if (eAnnotation == null) {
            return false;
        }
        for (EObject eReference : eAnnotation.getReferences()) {
            if (eReference == this.eContainmentFeature) {
                return true;
            }
            if (!(eReference instanceof EReference) || !this.isReferenced((EReference)eReference)) continue;
            return true;
        }
        return false;
    }
}

