/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.internal.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.elements.Nameable;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.internal.impl.DataTypeImpl;
import org.eclipse.ocl.examples.pivot.util.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleTypeImpl
extends DataTypeImpl
implements TupleType {
    private TupleTypeId tupleTypeId;

    protected TupleTypeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.TUPLE_TYPE;
    }

    public TupleTypeImpl(@NonNull TupleTypeId tupleTypeId) {
        this.tupleTypeId = tupleTypeId;
        this.setName(tupleTypeId.getName());
    }

    @Override
    @NonNull
    public TypeId computeId() {
        TupleTypeId tupleTypeId2 = this.tupleTypeId;
        if (tupleTypeId2 == null) {
            String name2 = DomainUtil.getSafeName((Nameable)this);
            List<Property> parts = this.getOwnedAttribute();
            int iSize = parts.size();
            ArrayList<TuplePartId> partIds = new ArrayList<TuplePartId>(iSize);
            int i = 0;
            while (i < iSize) {
                DomainTypedElement part = parts.get(i);
                String partName = DomainUtil.getSafeName((Nameable)part);
                TypeId partTypeId = part.getTypeId();
                partIds.add(IdManager.getTuplePartId((int)i, (String)partName, (TypeId)partTypeId));
                ++i;
            }
            this.tupleTypeId = tupleTypeId2 = IdManager.getTupleTypeId((String)name2, partIds);
        }
        return tupleTypeId2;
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitTupleType(this);
    }

    @Override
    @NonNull
    public DomainInheritance getInheritance(@NonNull DomainStandardLibrary standardLibrary) {
        DomainType tupleType = standardLibrary.getOclTupleType();
        return tupleType.getInheritance(standardLibrary);
    }

    @NonNull
    public TupleTypeId getTupleTypeId() {
        return this.getTypeId();
    }

    @NonNull
    public TupleTypeId getTypeId() {
        return (TupleTypeId)super.getTypeId();
    }
}

