/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.common.utils.EcoreUtils;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.library.oclstdlib.OCLstdlibPackage;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotObjectImpl;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2EcoreTypeRefVisitor
extends AbstractExtendingVisitor<EObject, Pivot2Ecore> {
    @NonNull
    protected final MetaModelManager metaModelManager;

    public Pivot2EcoreTypeRefVisitor(@NonNull Pivot2Ecore context) {
        super(context);
        this.metaModelManager = context.getMetaModelManager();
    }

    public EGenericType resolveEGenericType(Type type) {
        EObject eType = this.safeVisit(type);
        if (eType instanceof EGenericType) {
            return (EGenericType)eType;
        }
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setEClassifier((EClassifier)eType);
        return eGenericType;
    }

    @Override
    public EObject safeVisit(@Nullable Visitable v) {
        if (v instanceof Type) {
            v = this.metaModelManager.getPrimaryType((Type)v);
        }
        return v == null ? null : v.accept(this);
    }

    public <T extends EObject> void safeVisitAll(List<T> eObjects, List<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            EObject eObject = this.safeVisit(element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    @Override
    public EClassifier visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for Pivot2Ecore TypeRef pass");
    }

    @Override
    public EObject visitAnyType(@NonNull AnyType object) {
        return OCLstdlibPackage.Literals.OCL_ANY;
    }

    @Override
    public EObject visitCollectionType(@NonNull CollectionType object) {
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        EClassifier eClassifier = (EClassifier)EcoreUtils.getNamedElement((Collection)OCLstdlibPackage.eINSTANCE.getEClassifiers(), (String)object.getName());
        eGenericType.setEClassifier(eClassifier);
        this.safeVisitAll((List)eGenericType.getETypeArguments(), (List<? extends Element>)((TemplateBinding)object.getTemplateBinding().get(0)).getParameterSubstitution());
        return eGenericType;
    }

    @Override
    public EObject visitInvalidType(@NonNull InvalidType object) {
        return OCLstdlibPackage.Literals.OCL_INVALID;
    }

    @Override
    public EObject visitPrimitiveType(@NonNull PrimitiveType pivotType) {
        EDataType eClassifier = ((Pivot2Ecore)this.context).getCreated(EDataType.class, pivotType);
        if (eClassifier != null) {
            return eClassifier;
        }
        String uri = ((Pivot2Ecore)this.context).getPrimitiveTypesUriPrefix();
        if (uri != null) {
            URI proxyURI = URI.createURI((String)(String.valueOf(uri) + pivotType.getName()));
            eClassifier = EcoreFactory.eINSTANCE.createEDataType();
            ((InternalEObject)eClassifier).eSetProxyURI(proxyURI);
            ((Pivot2Ecore)this.context).putCreated(pivotType, (EModelElement)eClassifier);
            return eClassifier;
        }
        TypeServer typeServer = this.metaModelManager.getTypeServer(pivotType);
        for (DomainType domainType : typeServer.getPartialTypes()) {
            if (domainType instanceof PrimitiveType || (eClassifier = ((Pivot2Ecore)this.context).getCreated(EDataType.class, pivotType)) == null) continue;
            return eClassifier;
        }
        if (pivotType == this.metaModelManager.getBooleanType()) {
            return EcorePackage.Literals.EBOOLEAN;
        }
        if (pivotType == this.metaModelManager.getIntegerType()) {
            return EcorePackage.Literals.EBIG_INTEGER;
        }
        if (pivotType == this.metaModelManager.getRealType()) {
            return EcorePackage.Literals.EBIG_DECIMAL;
        }
        if (pivotType == this.metaModelManager.getStringType()) {
            return EcorePackage.Literals.ESTRING;
        }
        if (pivotType == this.metaModelManager.getUnlimitedNaturalType()) {
            return EcorePackage.Literals.EBIG_INTEGER;
        }
        throw new IllegalArgumentException("Unsupported primitive type '" + pivotType + "' in Pivot2Ecore TypeRef pass");
    }

    @Override
    public EObject visitTemplateBinding(@NonNull TemplateBinding object) {
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        return eGenericType;
    }

    @Override
    public EObject visitTemplateParameterSubstitution(@NonNull TemplateParameterSubstitution pivotTemplateParameterSubstitution) {
        EObject actualType = this.safeVisit(pivotTemplateParameterSubstitution.getActual());
        if (actualType instanceof EGenericType) {
            return actualType;
        }
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setEClassifier((EClassifier)actualType);
        return eGenericType;
    }

    @Override
    public EObject visitType(@NonNull Type pivotType) {
        TemplateParameter templateParameter = pivotType.getTemplateParameter();
        if (templateParameter != null) {
            ETypeParameter eTypeParameter = ((Pivot2Ecore)this.context).getCreated(ETypeParameter.class, templateParameter);
            EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
            eGenericType.setETypeParameter(eTypeParameter);
            return eGenericType;
        }
        List templateBindings = pivotType.getTemplateBinding();
        if (templateBindings.size() == 0) {
            EObject eObject;
            EClassifier eClassifier = ((Pivot2Ecore)this.context).getCreated(EClassifier.class, pivotType);
            if (eClassifier != null) {
                return eClassifier;
            }
            if (this.metaModelManager.isTypeServeable(pivotType)) {
                for (DomainType domainType : this.metaModelManager.getPartialTypes(pivotType)) {
                    EObject eTarget2;
                    if (!(domainType instanceof PivotObjectImpl) || (eTarget2 = ((PivotObjectImpl)domainType).getETarget()) == null) continue;
                    return eTarget2;
                }
            } else if (pivotType instanceof PivotObjectImpl && (eObject = ((PivotObjectImpl)((Object)pivotType)).getETarget()) != null) {
                return eObject;
            }
            return null;
        }
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        EObject eObject = this.safeVisit(PivotUtil.getUnspecializedTemplateableElement(pivotType));
        eGenericType.setEClassifier((EClassifier)eObject);
        this.safeVisitAll((List)eGenericType.getETypeArguments(), (List<? extends Element>)((TemplateBinding)templateBindings.get(0)).getParameterSubstitution());
        return eGenericType;
    }

    @Override
    public EObject visitVoidType(@NonNull VoidType object) {
        return OCLstdlibPackage.Literals.OCL_VOID;
    }
}

