/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.List;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluationEnvironment;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.library.AbstractOperation;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.context.OperationContext;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitorImpl;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class EObjectOperation
extends AbstractOperation {
    @NonNull
    protected final Operation operation;
    @NonNull
    protected final EOperation eFeature;
    @NonNull
    protected OpaqueExpression specification;
    private ExpressionInOCL expressionInOCL = null;

    public EObjectOperation(@NonNull Operation operation, @NonNull EOperation eFeature, @NonNull OpaqueExpression specification) {
        this.operation = operation;
        this.eFeature = eFeature;
        this.specification = specification;
    }

    @Nullable
    public Object dispatch(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue) {
        if (this.expressionInOCL == null) {
            this.resolveExpressionInOCL(evaluator, callExp, sourceValue);
        }
        List arguments = callExp.getArgument();
        Object[] argumentValues = new Object[arguments.size()];
        int i = 0;
        while (i < arguments.size()) {
            DomainExpression argument = (DomainExpression)arguments.get(i);
            assert (argument != null);
            argumentValues[i] = evaluator.evaluate(argument);
            ++i;
        }
        return this.evaluate(evaluator, callExp, sourceValue, argumentValues);
    }

    @Nullable
    private Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue, Object ... argumentValues) {
        if (this.expressionInOCL == null) {
            this.resolveExpressionInOCL(evaluator, callExp, sourceValue);
        }
        ExpressionInOCL expressionInOCL2 = this.expressionInOCL;
        assert (expressionInOCL2 != null);
        DomainEvaluator nestedEvaluator = evaluator instanceof EvaluationVisitorImpl ? ((EvaluationVisitorImpl)evaluator).createNestedUndecoratedEvaluator(expressionInOCL2) : evaluator.createNestedEvaluator();
        DomainEvaluationEnvironment nestedEvaluationEnvironment = nestedEvaluator.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add((DomainTypedElement)DomainUtil.nonNullModel((Object)expressionInOCL2.getContextVariable()), sourceValue);
        List<Variable> parameterVariables = expressionInOCL2.getParameterVariable();
        int iMax = Math.min(parameterVariables.size(), argumentValues.length);
        int i = 0;
        while (i < iMax) {
            nestedEvaluationEnvironment.add((DomainTypedElement)DomainUtil.nonNullModel((Object)parameterVariables.get(i)), argumentValues[i]);
            ++i;
        }
        try {
            Object object = nestedEvaluator.evaluate((DomainExpression)DomainUtil.nonNullPivot((Object)expressionInOCL2.getBodyExpression()));
            return object;
        }
        finally {
            nestedEvaluator.dispose();
        }
    }

    protected void resolveExpressionInOCL(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue) {
        if (this.specification instanceof ExpressionInOCL) {
            this.expressionInOCL = (ExpressionInOCL)this.specification;
        } else {
            String string = PivotUtil.getBody(this.specification);
            if (string != null) {
                try {
                    EvaluationVisitor evaluationVisitor = (EvaluationVisitor)evaluator;
                    MetaModelManager metaModelManager = evaluationVisitor.getMetaModelManager();
                    OperationContext operationContext = new OperationContext(metaModelManager, null, this.operation, null);
                    this.expressionInOCL = operationContext.parse(this.operation, string);
                }
                catch (ParserException e) {
                    throw new InvalidValueException((Exception)e, "parse failure", new Object[]{evaluator.getEvaluationEnvironment(), sourceValue, callExp});
                }
            }
            if (this.expressionInOCL == null) {
                Operation operation = ((OperationCallExp)callExp).getReferredOperation();
                throw new InvalidValueException("No specification for '" + operation + "'", new Object[]{evaluator.getEvaluationEnvironment(), sourceValue, callExp});
            }
        }
    }
}

