/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.eclipse.papyrus.infra.nattable.Activator;

public class TableClipboardUtils {
    @Deprecated
    public static final String AXIS_SEPARATOR = "\n";
    @Deprecated
    public static final String CELL_SEPARATOR = "\t";
    @Deprecated
    public static final String MULTI_VALUE_SEPARATOR = ",";

    private TableClipboardUtils() {
    }

    @Deprecated
    public static final String[] getRows(String fullContents) {
        String[] rows = fullContents.split(AXIS_SEPARATOR);
        return rows;
    }

    @Deprecated
    public static final String[] getRowsFromClipboard() {
        String clipboardContent = TableClipboardUtils.getClipboardContents();
        if (clipboardContent != null && !clipboardContent.isEmpty()) {
            return TableClipboardUtils.getRows(clipboardContent);
        }
        return null;
    }

    @Deprecated
    public static final String[] getColumnsFromClipboard() {
        String clipboardContent = TableClipboardUtils.getClipboardContents();
        if (clipboardContent != null && !clipboardContent.isEmpty()) {
            return TableClipboardUtils.getColumns(clipboardContent);
        }
        return null;
    }

    private static final String getClipboardContents() {
        String bufferSystem = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
            try {
                bufferSystem = clipboard.getData(DataFlavor.stringFlavor).toString();
            }
            catch (UnsupportedFlavorException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return bufferSystem;
    }

    public static final String getClipboardContentsAsString() {
        return TableClipboardUtils.getClipboardContents();
    }

    @Deprecated
    public static final String[] getCells(String row) {
        return row.split(CELL_SEPARATOR);
    }

    public static final String[] getColumns(String fullContents) {
        String[] rows = fullContents.split(AXIS_SEPARATOR);
        if (rows.length > 0) {
            int nbColumn = rows[0].split(CELL_SEPARATOR).length;
            String[] columns = new String[nbColumn];
            int columnIndex = 0;
            while (columnIndex < nbColumn) {
                columns[columnIndex] = "";
                ++columnIndex;
            }
            int rowIndex = 0;
            while (rowIndex < rows.length) {
                String row = rows[rowIndex];
                String[] currentColumns = row.split(CELL_SEPARATOR);
                int columnIndex2 = 0;
                while (columnIndex2 < nbColumn) {
                    if (currentColumns.length != 0) {
                        int n = columnIndex2;
                        columns[n] = String.valueOf(columns[n]) + currentColumns[columnIndex2];
                    } else {
                        int n = columnIndex2;
                        columns[n] = String.valueOf(columns[n]);
                    }
                    if (rowIndex < rows.length + 1) {
                        int n = columnIndex2;
                        columns[n] = String.valueOf(columns[n]) + CELL_SEPARATOR;
                    } else {
                        int n = columnIndex2;
                        columns[n] = String.valueOf(columns[n]) + AXIS_SEPARATOR;
                    }
                    ++columnIndex2;
                }
                ++rowIndex;
            }
            return columns;
        }
        return null;
    }
}

