/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;

public class HeaderAxisConfigurationManagementUtils {
    private HeaderAxisConfigurationManagementUtils() {
    }

    public static final AbstractHeaderAxisConfiguration getRowAbstractHeaderAxisInTable(Table table) {
        LocalTableHeaderAxisConfiguration config = table.getLocalRowHeaderAxisConfiguration();
        if (table.isInvertAxis()) {
            config = table.getLocalColumnHeaderAxisConfiguration();
        }
        return config;
    }

    public static final AbstractHeaderAxisConfiguration getRowAbstractHeaderAxisInTableConfiguration(Table table) {
        TableHeaderAxisConfiguration config = table.getTableConfiguration().getRowHeaderAxisConfiguration();
        if (table.isInvertAxis()) {
            config = table.getTableConfiguration().getColumnHeaderAxisConfiguration();
        }
        assert (config != null);
        return config;
    }

    public static final AbstractHeaderAxisConfiguration getAbstractHeaderAxisConfigurationUsedInTable(Table table) {
        AbstractHeaderAxisConfiguration config = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTable(table);
        if (config == null) {
            config = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration(table);
        }
        assert (config != null);
        return config;
    }

    public static final AbstractHeaderAxisConfiguration getColumnAbstractHeaderAxisInTable(Table table) {
        LocalTableHeaderAxisConfiguration config = table.getLocalColumnHeaderAxisConfiguration();
        if (table.isInvertAxis()) {
            config = table.getLocalRowHeaderAxisConfiguration();
        }
        return config;
    }

    public static final AbstractHeaderAxisConfiguration getColumnAbstractHeaderAxisInTableConfiguration(Table table) {
        TableHeaderAxisConfiguration config = table.getTableConfiguration().getColumnHeaderAxisConfiguration();
        if (table.isInvertAxis()) {
            config = table.getTableConfiguration().getRowHeaderAxisConfiguration();
        }
        assert (config != null);
        return config;
    }

    public static final AbstractHeaderAxisConfiguration getColumnAbstractHeaderAxisUsedInTable(Table table) {
        AbstractHeaderAxisConfiguration config = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisInTable(table);
        if (config == null) {
            config = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisInTableConfiguration(table);
        }
        assert (config != null);
        return config;
    }

    public static final AbstractHeaderAxisConfiguration getRowAbstractHeaderAxisUsedInTable(Table table) {
        AbstractHeaderAxisConfiguration config = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTable(table);
        if (config == null) {
            config = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration(table);
        }
        assert (config != null);
        return config;
    }

    public static LocalTableHeaderAxisConfiguration transformToLocalHeaderConfiguration(TableHeaderAxisConfiguration configuration) {
        LocalTableHeaderAxisConfiguration conf = NattableaxisconfigurationFactory.eINSTANCE.createLocalTableHeaderAxisConfiguration();
        conf.setDisplayFilter(configuration.isDisplayFilter());
        conf.setDisplayIndex(configuration.isDisplayIndex());
        conf.setDisplayLabel(configuration.isDisplayLabel());
        conf.setIndexStyle(configuration.getIndexStyle());
        return conf;
    }
}

