/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.editors.InputDialogWithLocation;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractAxisManager
implements IAxisManager {
    protected AxisManagerRepresentation representedAxisManager;
    private AbstractAxisProvider representedContentProvider;
    protected INattableModelManager tableManager;
    protected Adapter axisListener;
    private EObject tableContext;
    protected final List<Object> managedObject = new ArrayList<Object>();

    @Override
    public void init(INattableModelManager manager, AxisManagerRepresentation rep, AbstractAxisProvider provider) {
        this.tableManager = manager;
        this.representedAxisManager = rep;
        this.representedContentProvider = provider;
        this.tableContext = manager.getTable().getContext();
        this.initializeManagedObjectList();
        this.addListeners();
    }

    protected void addListeners() {
        this.axisListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                AbstractAxisManager.this.axisManagerHasChanged(notification);
            }
        };
        this.representedContentProvider.eAdapters().add((Object)this.axisListener);
    }

    protected void axisManagerHasChanged(Notification notification) {
    }

    protected void initializeManagedObjectList() {
    }

    @Override
    public boolean canBeSavedAsConfig() {
        return false;
    }

    @Override
    public NattableModelManager getTableManager() {
        return (NattableModelManager)this.tableManager;
    }

    @Override
    public boolean canInsertAxis(Collection<Object> objectsToAdd, int index) {
        return false;
    }

    @Override
    public boolean canCreateAxisElement(String elementId) {
        return false;
    }

    @Override
    public boolean canDropAxisElement(Collection<Object> objectsToAdd) {
        for (Object object : objectsToAdd) {
            if (!this.isAllowedContents(object) || this.isAlreadyManaged(object)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        this.removeListeners();
        this.tableContext = null;
    }

    protected void removeListeners() {
        if (this.axisListener != null) {
            this.representedContentProvider.eAdapters().remove((Object)this.axisListener);
            this.axisListener = null;
        }
    }

    @Override
    public boolean canBeUsedAsRowManager() {
        return true;
    }

    @Override
    public boolean canBeUsedAsColumnManager() {
        return true;
    }

    @Override
    public Command getAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        return null;
    }

    @Override
    public Command getInsertAxisCommand(Collection<Object> objectsToAdd, int index) {
        return null;
    }

    @Override
    public Command getComplementaryAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        return null;
    }

    @Override
    public AbstractAxisProvider getRepresentedContentProvider() {
        return this.representedContentProvider;
    }

    @Override
    public void setHeaderDataValue(int columnIndex, int rowIndex, Object newValue) {
    }

    @Override
    public boolean isAllowedContents(Object object) {
        return true;
    }

    @Override
    public boolean isAlreadyManaged(Object object) {
        return this.getElements().contains(object);
    }

    @Override
    public boolean canMoveAxis() {
        return true;
    }

    @Override
    public IRestrictedContentProvider createPossibleAxisContentProvider(boolean isRestricted) {
        return null;
    }

    @Override
    public Command getDestroyAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToDestroy) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.getRepresentedContentProvider());
        CompositeCommand compositeCommand = new CompositeCommand("Destroy IAxis Command");
        for (IAxis current : this.getRepresentedContentProvider().getAxis()) {
            if (current.getManager() != this.representedAxisManager || !objectToDestroy.contains(current) && !objectToDestroy.contains(current.getElement())) continue;
            DestroyElementRequest request = new DestroyElementRequest(domain, (EObject)current, false);
            compositeCommand.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        }
        if (!compositeCommand.isEmpty()) {
            return new GMFtoEMFCommandWrapper((ICommand)compositeCommand);
        }
        return null;
    }

    protected final EObject getTableContext() {
        return this.tableContext;
    }

    @Override
    public List<Object> getAllManagedAxis() {
        ArrayList<Object> eObjects = new ArrayList<Object>();
        for (IAxis current : this.getRepresentedContentProvider().getAxis()) {
            if (current.getManager() != this.representedAxisManager) continue;
            eObjects.add(current.getElement());
        }
        return eObjects;
    }

    protected TransactionalEditingDomain getTableEditingDomain() {
        ServicesRegistry registry = null;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)this.getTableManager().getTable());
            return (TransactionalEditingDomain)registry.getService(TransactionalEditingDomain.class);
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.NattableModelManager_ServiceRegistryNotFound, (Throwable)e);
            return null;
        }
    }

    protected TransactionalEditingDomain getContextEditingDomain() {
        ServicesRegistry registry = null;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(this.getTableContext());
            return (TransactionalEditingDomain)registry.getService(TransactionalEditingDomain.class);
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.NattableModelManager_ServiceRegistryNotFound, (Throwable)e);
            return null;
        }
    }

    @Override
    public void moveAxis(Object elementToMove, int newIndex) {
    }

    @Override
    public void openEditAxisAliasDialog(NatEventData event, int axisPosition) {
        IAxis axis = (IAxis)this.representedContentProvider.getAxis().get(axisPosition);
        String alias = axis.getAlias();
        if (alias == null) {
            alias = "";
        }
        String dialogMessage = String.format(Messages.AbstractAxisManager_InputDialogMessage, this.getElementAxisName(axis));
        Point location = new Point(event.getOriginalEvent().x, event.getOriginalEvent().y);
        NatTable natTable = event.getNatTable();
        location = natTable.toDisplay(location);
        InputDialogWithLocation dialog = new InputDialogWithLocation(Display.getDefault().getActiveShell(), Messages.AbstractAxisManager_InputDialogTitle, dialogMessage, alias, null, location);
        int result = dialog.open();
        if (result == 0) {
            String newAlias = dialog.getText();
            if ("".equals(newAlias)) {
                newAlias = null;
            }
            TransactionalEditingDomain domain = this.getTableEditingDomain();
            SetRequest request = new SetRequest(domain, (EObject)axis, (EStructuralFeature)NattableaxisPackage.eINSTANCE.getIAxis_Alias(), (Object)newAlias);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)axis);
            ICommand cmd = provider.getEditCommand((IEditCommandRequest)request);
            domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(cmd));
        }
    }

    @Override
    public String getElementAxisName(IAxis axis) {
        if (this.canEditAxisHeader()) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public AxisManagerRepresentation getAxisManagerRepresentation() {
        return this.representedAxisManager;
    }

    @Override
    public boolean canEditAxisHeader() {
        return false;
    }

    @Override
    public boolean canDestroyAxis(List<Integer> axisPositions) {
        if (axisPositions.isEmpty()) {
            return false;
        }
        for (Integer integer : axisPositions) {
            if (this.canDestroyAxis(integer)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canDestroyAxisElement(List<Integer> axisPositions) {
        if (axisPositions.isEmpty()) {
            return false;
        }
        for (Integer integer : axisPositions) {
            if (this.canDestroyAxisElement(integer)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void destroyAxis(List<Integer> axisPositions) {
        List<Object> toDestroy = this.getElements(axisPositions);
        TransactionalEditingDomain domain = this.getTableEditingDomain();
        Command cmd = this.getDestroyAxisCommand(domain, toDestroy);
        domain.getCommandStack().execute(cmd);
    }

    @Override
    public boolean canDestroyAxis(Integer axisPosition) {
        return !this.isDynamic();
    }

    protected List<Object> getElements(List<Integer> axisPositions) {
        List<Object> elements = this.getElements();
        ArrayList<Object> toDestroy = new ArrayList<Object>();
        for (Integer position : axisPositions) {
            Object element = elements.get(position);
            toDestroy.add(element);
        }
        return toDestroy;
    }

    @Override
    public void destroyAxisElement(List<Integer> axisPosition) {
        CompoundCommand cmd = new CompoundCommand("Destroy Axis Element Command");
        TransactionalEditingDomain domain = this.getContextEditingDomain();
        for (Integer integer : axisPosition) {
            cmd.append(this.getDestroyAxisElementCommand(domain, integer));
        }
        domain.getCommandStack().execute((Command)cmd);
    }

    protected final List<Object> getElements() {
        if (this.isUsedAsColumnManager()) {
            return this.tableManager.getColumnElementsList();
        }
        return this.tableManager.getRowElementsList();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public final boolean isUsedAsColumnManager() {
        Table table = this.getTableManager().getTable();
        AbstractAxisProvider columnAxisProvider = table.isInvertAxis() ? table.getCurrentRowAxisProvider() : table.getCurrentColumnAxisProvider();
        return columnAxisProvider == this.getRepresentedContentProvider();
    }
}

