/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.layerstack;

import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.action.MouseEditAction;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.action.RowReorderDragMode;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultSelectionBindings;
import org.eclipse.nebula.widgets.nattable.ui.action.AggregateDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.CellDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.papyrus.infra.nattable.configuration.PapyrusRowHeaderStyleConfiguration;
import org.eclipse.papyrus.infra.nattable.configuration.PapyrusRowResizeBindingsConfiguration;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;

public class RowHeaderLayerStack
extends AbstractLayerTransform {
    private static final int DEFAULT_COLUMN_WIDTH = 150;
    private static final int DEFAULT_ROW_HEIGHT = 20;

    public RowHeaderLayerStack(IDataProvider dataProvider, BodyLayerStack bodyLayer) {
        DataLayer dataLayer = new DataLayer(dataProvider, 150, 20);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)dataLayer, (ILayer)bodyLayer, new SelectionLayer((IUniqueIndexLayer)dataLayer), false);
        rowHeaderLayer.addConfiguration((IConfiguration)new PapyrusRowResizeBindingsConfiguration());
        rowHeaderLayer.addConfiguration((IConfiguration)new PapyrusRowHeaderStyleConfiguration());
        this.setUnderlyingLayer((ILayer)rowHeaderLayer);
        this.setRegionName("ROW_HEADER");
    }

    public class CustomConfig
    extends DefaultSelectionBindings {
        protected void configureRowHeaderMouseClickBindings(UiBindingRegistry uiBindingRegistry) {
            uiBindingRegistry.registerDoubleClickBinding((IMouseEventMatcher)MouseEventMatcher.columnHeaderLeftClick((int)0), (IMouseAction)new MouseEditAction());
        }
    }

    public class ReoderRowConfid
    extends AbstractUiBindingConfiguration {
        public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
            uiBindingRegistry.registerMouseDragMode((IMouseEventMatcher)MouseEventMatcher.rowHeaderLeftClick((int)0), (IDragMode)new AggregateDragMode(new IDragMode[]{new CellDragMode(), new RowReorderDragMode()}));
        }
    }
}

