/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultReferenceDescription;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.findrefs.TargetURIConverter;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IDependentElementsCalculator;
import org.eclipse.xtext.ui.refactoring.ILinkedPositionGroupCalculator;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IReferenceUpdater;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.IRenamedElementTracker;
import org.eclipse.xtext.ui.refactoring.impl.CachingResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.impl.IRefactoringDocument;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLinkedPositionGroupCalculator
implements ILinkedPositionGroupCalculator {
    private static final Logger LOG = Logger.getLogger(DefaultLinkedPositionGroupCalculator.class);
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    private RefactoringResourceSetProvider resourceSetProvider;
    @Inject
    private IGlobalServiceProvider globalServiceProvider;
    @Inject
    private IRenamedElementTracker renamedElementTracker;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private IReferenceUpdater referenceUpdater;
    @Inject
    private TargetURIConverter targetURIConverter;
    @Inject
    private Provider<LocalResourceRefactoringUpdateAcceptor> updateAcceptorProvider;

    @Override
    public Provider<LinkedPositionGroup> getLinkedPositionGroup(IRenameElementContext renameElementContext, IProgressMonitor monitor) {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final XtextEditor editor = (XtextEditor)renameElementContext.getTriggeringEditor();
        IProject project = this.projectUtil.getProject(renameElementContext.getContextResourceURI());
        if (project == null) {
            throw new IllegalStateException("Could not determine project for context resource " + renameElementContext.getContextResourceURI());
        }
        CachingResourceSetProvider resourceSetProvider = new CachingResourceSetProvider(this.resourceSetProvider);
        ResourceSet resourceSet = ((RefactoringResourceSetProvider)resourceSetProvider).get(project);
        EObject targetElement = resourceSet.getEObject(renameElementContext.getTargetElementURI(), true);
        if (targetElement == null) {
            throw new IllegalStateException("Target element could not be loaded");
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IRenameStrategy.Provider strategyProvider = (IRenameStrategy.Provider)this.globalServiceProvider.findService(targetElement, IRenameStrategy.Provider.class);
        IRenameStrategy renameStrategy = null;
        try {
            renameStrategy = strategyProvider.get(targetElement, renameElementContext);
        }
        catch (IRenameStrategy.Provider.NoSuchStrategyException noSuchStrategyException) {
            // empty catch block
        }
        if (renameStrategy == null) {
            throw new IllegalArgumentException("Cannot find a rename strategy for " + Strings.notNull((Object)renameElementContext.getTargetElementURI()));
        }
        String newName = renameStrategy.getOriginalName();
        IResourceServiceProvider resourceServiceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(renameElementContext.getTargetElementURI());
        IDependentElementsCalculator dependentElementsCalculator = (IDependentElementsCalculator)resourceServiceProvider.get(IDependentElementsCalculator.class);
        Iterable<URI> dependentElementURIs = dependentElementsCalculator.getDependentElementURIs(targetElement, (IProgressMonitor)progress.newChild(10));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        LocalResourceRefactoringUpdateAcceptor updateAcceptor = (LocalResourceRefactoringUpdateAcceptor)this.updateAcceptorProvider.get();
        updateAcceptor.setLocalResourceURI(renameElementContext.getContextResourceURI());
        renameStrategy.createDeclarationUpdates(newName, resourceSet, updateAcceptor);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        Map<URI, URI> original2newEObjectURI = this.renamedElementTracker.renameAndTrack(Iterables.concat(Collections.singleton(renameElementContext.getTargetElementURI()), dependentElementURIs), newName, resourceSet, renameStrategy, (IProgressMonitor)progress.newChild(10));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ElementRenameArguments elementRenameArguments = new ElementRenameArguments(renameElementContext.getTargetElementURI(), newName, renameStrategy, original2newEObjectURI, resourceSetProvider);
        final ArrayList referenceDescriptions = Lists.newArrayList();
        IReferenceFinder.Acceptor referenceAcceptor = new IReferenceFinder.Acceptor(){

            public void accept(IReferenceDescription referenceDescription) {
                referenceDescriptions.add(referenceDescription);
            }

            public void accept(EObject source, URI sourceURI, EReference eReference, int index, EObject targetOrProxy, URI targetURI) {
                referenceDescriptions.add(new DefaultReferenceDescription(sourceURI, targetURI, eReference, index, null));
            }
        };
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.referenceFinder.findReferences(this.targetURIConverter.fromIterable(elementRenameArguments.getRenamedElementURIs()), resourceSet.getResource(renameElementContext.getContextResourceURI(), true), referenceAcceptor, (IProgressMonitor)progress.newChild(10));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.referenceUpdater.createReferenceUpdates(elementRenameArguments, referenceDescriptions, updateAcceptor, (IProgressMonitor)progress.newChild(60));
        final List<ReplaceEdit> textEdits = updateAcceptor.getTextEdits();
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        final IRenameStrategy renameStrategy2 = renameStrategy;
        return new Provider<LinkedPositionGroup>(){

            public LinkedPositionGroup get() {
                LinkedPositionGroup linkedGroup = DefaultLinkedPositionGroupCalculator.this.createLinkedGroupFromReplaceEdits(textEdits, editor, renameStrategy2.getOriginalName(), progress.newChild(10));
                return linkedGroup;
            }
        };
    }

    protected LinkedPositionGroup createLinkedGroupFromReplaceEdits(List<ReplaceEdit> edits, XtextEditor xtextEditor, final String originalName, SubMonitor progress) {
        if (edits == null) {
            return null;
        }
        final IXtextDocument document = xtextEditor.getDocument();
        LinkedPositionGroup group = new LinkedPositionGroup();
        Iterable linkedPositions = Iterables.filter((Iterable)Iterables.transform(edits, (Function)new Function<ReplaceEdit, LinkedPosition>(){

            public LinkedPosition apply(ReplaceEdit edit) {
                try {
                    String textToReplace = document.get(edit.getOffset(), edit.getLength());
                    int indexOf = textToReplace.indexOf(originalName);
                    if (indexOf != -1) {
                        int calculatedOffset = edit.getOffset() + indexOf;
                        return new LinkedPosition((IDocument)document, calculatedOffset, originalName.length());
                    }
                }
                catch (BadLocationException exc) {
                    LOG.error((Object)("Skipping invalid text edit " + Strings.notNull((Object)edit)), (Throwable)exc);
                }
                return null;
            }
        }), (Predicate)Predicates.notNull());
        progress.worked(10);
        int invocationOffset = xtextEditor.getInternalSourceViewer().getSelectedRange().x;
        int i = 0;
        for (LinkedPosition position : this.sortPositions(linkedPositions, invocationOffset)) {
            try {
                position.setSequenceNumber(i);
                ++i;
                group.addPosition(position);
            }
            catch (BadLocationException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return group;
    }

    protected Iterable<LinkedPosition> sortPositions(Iterable<LinkedPosition> linkedPositions, final int invocationOffset) {
        Comparator<LinkedPosition> comparator = new Comparator<LinkedPosition>(){

            @Override
            public int compare(LinkedPosition left, LinkedPosition right) {
                return this.rank(left) - this.rank(right);
            }

            private int rank(LinkedPosition o1) {
                int relativeRank = o1.getOffset() + o1.length - invocationOffset;
                if (relativeRank < 0) {
                    return Integer.MAX_VALUE + relativeRank;
                }
                return relativeRank;
            }
        };
        return ImmutableSortedSet.copyOf((Comparator)comparator, linkedPositions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocalResourceRefactoringUpdateAcceptor
    implements IRefactoringUpdateAcceptor {
        @Inject
        private IRefactoringDocument.Provider refactoringDocumentProvider;
        @Inject
        private StatusWrapper status;
        private List<ReplaceEdit> textEdits = Lists.newArrayList();
        private URI localResourceURI;

        public void setLocalResourceURI(URI localResourceURI) {
            this.localResourceURI = localResourceURI;
        }

        public List<ReplaceEdit> getTextEdits() {
            return this.textEdits;
        }

        @Override
        public StatusWrapper getRefactoringStatus() {
            return this.status;
        }

        @Override
        public IRefactoringDocument getDocument(URI resourceURI) {
            return this.refactoringDocumentProvider.get(resourceURI, this.status);
        }

        @Override
        public Change createCompositeChange(String name, IProgressMonitor monitor) {
            return null;
        }

        @Override
        public void accept(URI resourceURI, Change change) {
        }

        @Override
        public void accept(URI resourceURI, TextEdit textEdit) {
            if (this.localResourceURI.equals(resourceURI) && textEdit instanceof ReplaceEdit) {
                this.textEdits.add((ReplaceEdit)textEdit);
            }
        }
    }
}

