/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAccess
implements IReferenceFinder.ILocalResourceAccess {
    private Map<IProject, ResourceSet> resourceSets = Maps.newHashMap();
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    private ResourceSet fallBackResourceSet;

    public void registerResourceSet(ResourceSet resourceSet) {
        Object context;
        if (resourceSet instanceof XtextResourceSet && (context = ((XtextResourceSet)resourceSet).getClasspathURIContext()) instanceof IJavaProject) {
            IProject project = ((IJavaProject)context).getProject();
            this.resourceSets.put(project, resourceSet);
        }
        this.fallBackResourceSet = resourceSet;
    }

    public <R> R readOnly(URI targetURI, IUnitOfWork<R, ResourceSet> work) {
        URI resourceURI = targetURI.trimFragment();
        Iterable<Pair<IStorage, IProject>> storages = this.storage2UriMapper.getStorages(resourceURI);
        Iterator<Pair<IStorage, IProject>> iterator = storages.iterator();
        ResourceSet resourceSet = this.fallBackResourceSet;
        while (iterator.hasNext()) {
            Pair<IStorage, IProject> pair = iterator.next();
            IProject project = (IProject)pair.getSecond();
            if (project == null) continue;
            resourceSet = this.getResourceSet(project);
            break;
        }
        if (resourceSet != null) {
            resourceSet.getResource(resourceURI, true);
            try {
                return (R)work.exec((Object)resourceSet);
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
        return null;
    }

    protected ResourceSet getResourceSet(IProject p) {
        if (this.resourceSets.isEmpty() && this.fallBackResourceSet != null) {
            return this.fallBackResourceSet;
        }
        if (this.resourceSets.containsKey(p)) {
            return this.resourceSets.get(p);
        }
        ResourceSet resourceSet = this.resourceSetProvider.get(p);
        if (resourceSet == null) {
            return null;
        }
        this.resourceSets.put(p, resourceSet);
        return resourceSet;
    }
}

