/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.wizard;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecoretools.design.service.EcoreToolsDesignPlugin;
import org.eclipse.emf.importer.ecore.EcoreImporter;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.DefaultLocalSessionCreationOperation;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreModelingProjectCreationOperation
extends WorkspaceModifyOperation {
    private IProject project;
    private EObject rootObject;
    private String ecoreResourceName;
    private String genModelResourceName;
    private String representationsResourceName;
    private Set<Viewpoint> selectedViewpoints;
    private IFile ecoreModel;
    private IWorkbench workbench;
    private IPath genModelContainerPath;
    private IPath genModelProjectLocation;
    private IWorkingSet[] selectedWorkingSets;

    public EcoreModelingProjectCreationOperation(EObject rootObject, String ecoreResourceName, String genModelResourceName, String representationsResourceName, Set<Viewpoint> selectedViewpoints, IWorkbench workbench, IPath genModelContainerPath, IPath genModelProjectLocation, IWorkingSet[] selectedWorkingSets) {
        this.workbench = workbench;
        this.rootObject = rootObject;
        this.ecoreResourceName = ecoreResourceName;
        this.genModelContainerPath = genModelContainerPath;
        this.genModelProjectLocation = genModelProjectLocation;
        this.genModelResourceName = genModelResourceName;
        this.representationsResourceName = representationsResourceName;
        this.selectedViewpoints = selectedViewpoints;
        this.selectedWorkingSets = selectedWorkingSets;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Create modeling resources: ", 100);
            try {
                this.modifyWorkspace(monitor);
            }
            catch (UnsupportedEncodingException e) {
                this.logError(e);
            }
            catch (IOException e) {
                this.logError(e);
            }
            this.ecoreModel = this.createModelingResources(this.project, monitor);
            monitor.subTask("prepare the modeling project...");
            this.convertToModelingProject((IProgressMonitor)new SubProgressMonitor(monitor, 20));
        }
        finally {
            monitor.done();
        }
    }

    protected void logError(Throwable e) {
        Status status = new Status(4, "org.eclipse.emf.ecoretools.design", 4, e.getMessage(), e);
        EcoreToolsDesignPlugin.getDefault().getLog().log((IStatus)status);
    }

    public void modifyWorkspace(IProgressMonitor progressMonitor) throws CoreException, UnsupportedEncodingException, IOException {
        this.project = Generator.createEMFProject((IPath)new Path(this.genModelContainerPath.toString()), (IPath)this.genModelProjectLocation, Collections.emptyList(), (IProgressMonitor)progressMonitor, (int)(Generator.EMF_MODEL_PROJECT_STYLE | Generator.EMF_PLUGIN_PROJECT_STYLE));
        if (this.selectedWorkingSets != null) {
            this.workbench.getWorkingSetManager().addToWorkingSets((IAdaptable)this.project, this.selectedWorkingSets);
        }
        CodeGenUtil.EclipseUtil.findOrCreateContainer((IPath)new Path("/" + this.genModelContainerPath.segment(0) + "/model"), (boolean)true, (IPath)this.genModelProjectLocation, (IProgressMonitor)progressMonitor);
        PrintStream manifest = new PrintStream(URIConverter.INSTANCE.createOutputStream(URI.createPlatformResourceURI((String)("/" + this.genModelContainerPath.segment(0) + "/META-INF/MANIFEST.MF"), (boolean)true), null), false, "UTF-8");
        manifest.println("Manifest-Version: 1.0");
        manifest.println("Bundle-ManifestVersion: 2");
        manifest.print("Bundle-Name: ");
        manifest.println(this.genModelContainerPath.segment(0));
        manifest.print("Bundle-SymbolicName: ");
        manifest.print(CodeGenUtil.validPluginID((String)this.genModelContainerPath.segment(0)));
        manifest.println("; singleton:=true");
        manifest.println("Bundle-Version: 0.1.0.qualifier");
        manifest.print("Require-Bundle: ");
        String[] requiredBundles = this.getRequiredBundles();
        int i = 0;
        int size = requiredBundles.length;
        while (i < size) {
            manifest.print(requiredBundles[i]);
            if (++i == size) {
                manifest.println();
                break;
            }
            manifest.println(",");
            manifest.print(" ");
        }
        manifest.close();
    }

    protected String[] getRequiredBundles() {
        return new String[]{"org.eclipse.emf.ecore"};
    }

    private IFile createModelingResources(IProject project, IProgressMonitor monitor) {
        monitor.subTask("create the ecore model.");
        String modelPath = String.valueOf('/') + project.getName() + "/model/";
        String ecorePath = this.createEcoreResource(modelPath);
        IFile ecoreFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(ecorePath));
        monitor.worked(10);
        monitor.subTask("create the genmodel...");
        this.createGenModel(ecoreFile, modelPath, (IProgressMonitor)new SubProgressMonitor(monitor, 15));
        monitor.subTask("create the representation model...");
        Session session = this.createAird(project, URI.createPlatformResourceURI((String)(String.valueOf(modelPath) + this.representationsResourceName), (boolean)true), monitor);
        monitor.worked(15);
        if (session == null) {
            return null;
        }
        session.getTransactionalEditingDomain().getResourceSet().getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        monitor.subTask("prepare ecore modeling project...");
        CompoundCommand cc = new CompoundCommand("Prepare Ecore Modeling Project");
        cc.append((Command)new AddSemanticResourceCommand(session, URI.createPlatformResourceURI((String)ecorePath, (boolean)true), (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        cc.append((Command)new ChangeViewpointSelectionCommand(session, (ViewpointSelection.Callback)new ViewpointSelectionCallback(), this.selectedViewpoints, Collections.emptySet(), (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        monitor.subTask("link the created models...");
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)cc);
        monitor.worked(10);
        session.save(monitor);
        monitor.worked(15);
        return ecoreFile;
    }

    private void convertToModelingProject(IProgressMonitor monitor) {
        try {
            ModelingProjectManager.INSTANCE.convertToModelingProject(this.project, monitor);
        }
        catch (CoreException e) {
            this.logError(e);
        }
    }

    private Session createAird(IProject project, URI representationsURI, IProgressMonitor monitor) {
        Object session;
        Option modelingProject = ModelingProject.asModelingProject((IProject)project);
        if (modelingProject.some()) {
            session = ((ModelingProject)modelingProject.get()).getSession();
        } else {
            Session tempSession = null;
            DefaultLocalSessionCreationOperation sessionCreationOperation = new DefaultLocalSessionCreationOperation(representationsURI, monitor);
            try {
                sessionCreationOperation.execute();
                tempSession = sessionCreationOperation.getCreatedSession();
            }
            catch (CoreException e) {
                this.logError(e);
            }
            session = tempSession != null ? tempSession : null;
        }
        return session;
    }

    private void createGenModel(IFile ecoreModel, String modelPath, IProgressMonitor progressMonitor) {
        EcoreImporter genModelCreator = new EcoreImporter();
        genModelCreator.setGenModelContainerPath((IPath)new Path(modelPath));
        genModelCreator.setGenModelFileName(this.genModelResourceName);
        genModelCreator.setModelFile(ecoreModel);
        genModelCreator.getFileExtensions().clear();
        genModelCreator.getFileExtensions().add(ecoreModel.getFileExtension());
        Monitor monitor = BasicMonitor.toMonitor((IProgressMonitor)progressMonitor);
        try {
            try {
                genModelCreator.computeEPackages(monitor);
                genModelCreator.adjustEPackages(monitor);
                genModelCreator.prepareGenModelAndEPackages(monitor);
                genModelCreator.saveGenModelAndEPackages(monitor);
            }
            catch (Exception exception) {
                Status status = new Status(4, "org.eclipse.emf.ecoretools.design", 4, "Error occurs during generating the genmodel file.", (Throwable)exception);
                EcoreToolsDesignPlugin.getDefault().getLog().log((IStatus)status);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private String createEcoreResource(String modelPath) {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        String platformPath = String.valueOf(modelPath) + this.ecoreResourceName;
        URI semanticModelURI = URI.createPlatformResourceURI((String)platformPath, (boolean)true);
        Resource resource = rs.createResource(semanticModelURI);
        if (this.rootObject != null) {
            resource.getContents().add((Object)this.rootObject);
        }
        try {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", "UTF-8");
            resource.save(options);
        }
        catch (IOException iOException) {}
        return platformPath;
    }

    public IFile getEcoreModel() {
        return this.ecoreModel;
    }

    public IProject getNewProject() {
        return this.project;
    }
}

