/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecoretools.design.service.AutosizeTrigger;
import org.eclipse.emf.ecoretools.design.service.GenModelAutoReload;
import org.eclipse.emf.ecoretools.design.service.GenModelUpdateGenFeatureContainment;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.osgi.framework.BundleContext;

public class EcoreToolsDesignPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.ecoretools.design";
    private static EcoreToolsDesignPlugin plugin;
    private static Set<Viewpoint> viewpoints;
    private SessionManagerListener notifWhenSessionAreCreated;

    public EcoreToolsDesignPlugin() {
        plugin = this;
    }

    public static EcoreToolsDesignPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        viewpoints = new HashSet<Viewpoint>();
        viewpoints.addAll(ViewpointRegistry.getInstance().registerFromPlugin("org.eclipse.emf.ecoretools.design/description/ecore.odesign"));
        this.notifWhenSessionAreCreated = new SessionManagerListener.Stub(){

            public void notifyAddSession(Session newSession) {
                Method computePlatformURIMap;
                ResourceSet set = newSession.getTransactionalEditingDomain().getResourceSet();
                Map result = null;
                try {
                    computePlatformURIMap = EcorePlugin.class.getMethod("computePlatformURIMap", Boolean.class);
                    result = (Map)computePlatformURIMap.invoke(null, true);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
                try {
                    computePlatformURIMap = EcorePlugin.class.getMethod("computePlatformURIMap", new Class[0]);
                    result = (Map)computePlatformURIMap.invoke(null, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
                if (result != null) {
                    set.getURIConverter().getURIMap().putAll(result);
                } else {
                    Status status = new Status(2, EcoreToolsDesignPlugin.PLUGIN_ID, "The EMF API EcorePlugin.computePlatformURIMap has probably changed and is not supported yet by EcoreTools.");
                    EcoreToolsDesignPlugin.getDefault().getLog().log((IStatus)status);
                }
                newSession.getEventBroker().addLocalTrigger(GenModelAutoReload.SHOULD_RELOAD, (ModelChangeTrigger)new GenModelAutoReload(newSession.getTransactionalEditingDomain()));
                newSession.getEventBroker().addLocalTrigger(GenModelUpdateGenFeatureContainment.SHOULD_UPDATE, (ModelChangeTrigger)new GenModelUpdateGenFeatureContainment(newSession));
                newSession.getEventBroker().addLocalTrigger(AutosizeTrigger.IS_GMF_NODE_ATTACHMENT, (ModelChangeTrigger)new AutosizeTrigger(newSession.getTransactionalEditingDomain()));
            }
        };
        SessionManager.INSTANCE.addSessionsListener(this.notifWhenSessionAreCreated);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (viewpoints != null) {
            for (Viewpoint viewpoint : viewpoints) {
                ViewpointRegistry.getInstance().disposeFromPlugin(viewpoint);
            }
            viewpoints.clear();
            viewpoints = null;
        }
        if (this.notifWhenSessionAreCreated != null) {
            SessionManager.INSTANCE.removeSessionsListener(this.notifWhenSessionAreCreated);
        }
        super.stop(context);
    }
}

