/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import java.util.Map;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecoretools.design.service.DesignServices;

public class ArchetypeServices
extends DesignServices {
    private static final String ARCHETYPE_URI = "http://www.obeo.fr/dsl/dnc/archetype";

    public void addArchetypeAnnotation(EClass clazz, String archetype) {
        EAnnotation annot = clazz.getEAnnotation(ARCHETYPE_URI);
        if (annot == null) {
            annot = EcoreFactory.eINSTANCE.createEAnnotation();
            annot.setSource(ARCHETYPE_URI);
            clazz.getEAnnotations().add((Object)annot);
        }
        annot.getDetails().put((Object)"archetype", (Object)archetype);
    }

    public boolean isMomentInterval(EObject clazz) {
        return this.hasArchetypeAnnotation(clazz, "MomentInterval");
    }

    public boolean isDescription(EObject clazz) {
        return this.hasArchetypeAnnotation(clazz, "Description");
    }

    public boolean isThing(EObject clazz) {
        return this.hasArchetypeAnnotation(clazz, "Thing");
    }

    public boolean isRole(EObject clazz) {
        return this.hasArchetypeAnnotation(clazz, "Role");
    }

    private boolean hasArchetypeAnnotation(EObject clazz, String string) {
        EAnnotation annot;
        if (clazz instanceof EModelElement && (annot = ((EModelElement)clazz).getEAnnotation(ARCHETYPE_URI)) != null) {
            for (Map.Entry entry : annot.getDetails().entrySet()) {
                if (!"archetype".equals(entry.getKey()) || !string.equals(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }
}

