/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.command.SequenceDelegatingCommandFactory;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.SequenceGraphicalHelper;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.EditPartsHelper;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.CreationUtil;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LaunchToolEditPolicy;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;

public class SequenceLaunchToolEditPolicy
extends LaunchToolEditPolicy {
    protected CreationUtil getCreationUtil(CreateRequest request, Point location, EditPart editPart, IDiagramCommandFactory baseEmfCommandFactory) {
        IDiagramCommandFactory launchToolCommandFactory = baseEmfCommandFactory;
        Object tool = request.getNewObject();
        if (tool instanceof ToolDescription || tool instanceof PaneBasedSelectionWizardDescription || tool instanceof SelectionWizardDescription) {
            launchToolCommandFactory = this.getLaunchToolCommandFactory(editPart, request.getLocation().getCopy(), baseEmfCommandFactory);
        }
        return super.getCreationUtil(request, location, editPart, launchToolCommandFactory);
    }

    private IDiagramCommandFactory getLaunchToolCommandFactory(EditPart editPart, Point requestLocation, IDiagramCommandFactory baseEmfCommandFactory) {
        SequenceDiagram sequenceDiagram;
        IDiagramCommandFactory result = baseEmfCommandFactory;
        Point location = requestLocation.getCopy();
        if (editPart instanceof IGraphicalEditPart) {
            GraphicalHelper.screen2logical((Point)location, (IGraphicalEditPart)((IGraphicalEditPart)editPart));
        }
        if ((sequenceDiagram = EditPartsHelper.getSequenceDiagram(editPart)) != null) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)sequenceDiagram.getNotationDiagram());
            SequenceDDiagram diagram = sequenceDiagram.getSequenceDDiagram();
            EventEnd endBefore = SequenceGraphicalHelper.getEndBefore(diagram, location.y);
            result = new SequenceDelegatingCommandFactory(baseEmfCommandFactory, domain, sequenceDiagram, endBefore, location.getCopy());
        }
        return result;
    }
}

