/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.VerticalSpaceExpansion;
import org.eclipse.sirius.diagram.sequence.description.tool.CombinedFragmentCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.InstanceRoleCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.InteractionUseCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.ObservationPointCreationTool;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.command.SequenceDelegatingCommandFactory;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceDiagramEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceInteractionFeedBackBuilder;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.FrameCreationValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.SequenceGraphicalHelper;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.CreateRequestQuery;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.EditPartsHelper;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.ContainerCreationEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.CreationUtil;
import org.eclipse.sirius.diagram.ui.tools.api.command.DoNothingCommand;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public class SequenceContainerCreationPolicy
extends ContainerCreationEditPolicy {
    public static final String INTERACTION_USE_CREATION_CMD_LABEL = "Interaction Use creation";
    public static final String COMBINED_FRAGMENT_CREATION_CMD_LABEL = "Combined Fragment creation";
    protected Collection<Figure> guides = Lists.newArrayList();

    protected Command getCreateNodeOnDiagramCommand(CreateRequest request, NodeCreationDescription tool, DDiagram diagram) {
        Command result;
        if (tool instanceof ObservationPointCreationTool && diagram instanceof SequenceDDiagram) {
            EventEnd startingEndPredecessor;
            SequenceDDiagram diag = (SequenceDDiagram)diagram;
            Point location = request.getLocation().getCopy();
            GraphicalHelper.screen2logical((Point)location, (IGraphicalEditPart)((IGraphicalEditPart)this.getHost()));
            EventEnd finishingEndEndPredecessor = startingEndPredecessor = SequenceGraphicalHelper.getEndBefore(diag, location.y);
            if (request.getSize() != null) {
                Dimension size = request.getSize().getCopy();
                GraphicalHelper.screen2logical((Dimension)size, (IGraphicalEditPart)((IGraphicalEditPart)this.getHost()));
                finishingEndEndPredecessor = SequenceGraphicalHelper.getEndBefore(diag, location.y + size.height);
            }
            CreationUtil creationUtil = new CreationUtil(request, this.getDiagramCommandFactory(startingEndPredecessor, finishingEndEndPredecessor, location), this.getRealLocation(request), request.getSize(), this.getHost());
            result = creationUtil.getNodeCreationCommand(diagram, tool);
        } else if (tool instanceof InstanceRoleCreationTool && diagram instanceof SequenceDDiagram) {
            SequenceDDiagram diag = (SequenceDDiagram)diagram;
            Point location = request.getLocation().getCopy();
            GraphicalHelper.screen2logical((Point)location, (IGraphicalEditPart)((IGraphicalEditPart)this.getHost()));
            EObject predecessor = SequenceGraphicalHelper.getInstanceRoleBefore(diag, location.x);
            CreationUtil creationUtil = new CreationUtil(request, this.getDiagramCommandFactory(predecessor, location), this.getRealLocation(request), request.getSize(), this.getHost());
            result = creationUtil.getNodeCreationCommand(diagram, tool);
        } else {
            result = super.getCreateNodeOnDiagramCommand(request, tool, diagram);
        }
        return result;
    }

    protected Command getCreateContainerOnDiagramCommand(CreateRequest request, ContainerCreationDescription ccdTool, DDiagram diagram) {
        Command result;
        boolean frameCreationTool;
        boolean bl = frameCreationTool = ccdTool instanceof InteractionUseCreationTool || ccdTool instanceof CombinedFragmentCreationTool;
        if (frameCreationTool && this.getHost() instanceof SequenceDiagramEditPart && diagram instanceof SequenceDDiagram) {
            SequenceDiagramEditPart sdep = (SequenceDiagramEditPart)this.getHost();
            TransactionalEditingDomain domain = sdep.getEditingDomain();
            Diagram gmfDiagram = sdep.getDiagramView();
            SequenceDiagram sequenceDiagram = (SequenceDiagram)ISequenceElementAccessor.getSequenceDiagram((Diagram)gmfDiagram).get();
            FrameCreationValidator creationValidator = FrameCreationValidator.getOrCreateValidator(sequenceDiagram, ccdTool, new CreateRequestQuery(request, sdep));
            if (creationValidator.isValid()) {
                EventEnd startingEndPredecessor = creationValidator.getStartingEndPredecessor();
                EventEnd finishingEndPredecessor = creationValidator.getFinishingEndPredecessor();
                List<EObject> coverage = creationValidator.getCoverage();
                Range expansionZone = creationValidator.getExpansionZone();
                CreationUtil creationUtil = new CreationUtil(request, this.getDiagramCommandFactory(startingEndPredecessor, finishingEndPredecessor, coverage, this.getCreationRange(request)), this.getRealLocation(request), this.getRealSize(ccdTool, request), this.getHost());
                result = creationUtil.getContainerCreationDescription(diagram, ccdTool);
                if (expansionZone != null && !expansionZone.isEmpty() && result != null && result.canExecute()) {
                    VerticalSpaceExpansion verticalSpaceExpansion = new VerticalSpaceExpansion(sequenceDiagram, expansionZone, Integer.valueOf(0), Collections.emptyList());
                    ICommand expandSubEventsCmd = CommandFactory.createICommand((TransactionalEditingDomain)domain, (AbstractModelChangeOperation)verticalSpaceExpansion);
                    result = new ICommandProxy(expandSubEventsCmd).chain(result);
                }
                if (result != null) {
                    if (ccdTool instanceof InteractionUseCreationTool) {
                        result.setLabel(INTERACTION_USE_CREATION_CMD_LABEL);
                    } else if (ccdTool instanceof CombinedFragmentCreationTool) {
                        result.setLabel(COMBINED_FRAGMENT_CREATION_CMD_LABEL);
                    }
                }
            } else {
                result = creationValidator.getCoverage().isEmpty() ? DoNothingCommand.INSTANCE : UnexecutableCommand.INSTANCE;
            }
        } else {
            result = super.getCreateContainerOnDiagramCommand(request, ccdTool, diagram);
        }
        return result;
    }

    public void showTargetFeedback(Request request) {
        this.eraseTargetFeedback(request);
        if (request instanceof CreateRequest && "create child".equals(request.getType()) && this.getHost() instanceof SequenceDiagramEditPart) {
            FrameCreationValidator validator;
            SequenceDiagramEditPart sdep = (SequenceDiagramEditPart)this.getHost();
            CreateRequest createRequest = (CreateRequest)request;
            Option seqDiag = ISequenceElementAccessor.getISequenceElement((View)((View)this.getHost().getModel()));
            AbstractToolDescription tool = this.getTool(createRequest);
            if (seqDiag.some() && seqDiag.get() instanceof SequenceDiagram && (tool instanceof InteractionUseCreationTool || tool instanceof CombinedFragmentCreationTool) && (validator = FrameCreationValidator.getOrCreateValidator((SequenceDiagram)seqDiag.get(), (ContainerCreationDescription)tool, new CreateRequestQuery(createRequest, sdep))) != null) {
                SequenceInteractionFeedBackBuilder feedBackBuilder = new SequenceInteractionFeedBackBuilder(validator, this.getFeedbackLayer(), (IGraphicalEditPart)this.getHost());
                for (Figure fig : feedBackBuilder.buildFeedBack()) {
                    this.addFeedback((IFigure)fig);
                    this.guides.add(fig);
                }
            }
        }
    }

    public void eraseTargetFeedback(Request request) {
        this.removeFeedBackOnGuides();
    }

    private void removeFeedBackOnGuides() {
        if (this.guides != null && !this.guides.isEmpty()) {
            for (Figure hGuide : this.guides) {
                this.removeFeedback((IFigure)hGuide);
            }
            this.guides.clear();
        }
    }

    protected void addFeedback(IFigure figure) {
        this.getFeedbackLayer().add(figure);
    }

    protected IFigure getFeedbackLayer() {
        return this.getLayer("Feedback Layer");
    }

    protected IFigure getHostFigure() {
        return ((GraphicalEditPart)this.getHost()).getFigure();
    }

    protected IFigure getLayer(Object layer) {
        return LayerManager.Helper.find((EditPart)this.getHost()).getLayer(layer);
    }

    protected void removeFeedback(IFigure figure) {
        this.getFeedbackLayer().remove(figure);
    }

    private Range getCreationRange(CreateRequest request) {
        Point realLocation = this.getRealLocation(request);
        Range result = Range.emptyRange();
        if (request.getSize() != null) {
            result = new Range(realLocation.y, realLocation.y + request.getSize().height);
        }
        return result;
    }

    private Dimension getRealSize(ContainerCreationDescription ccdTool, CreateRequest request) {
        Dimension realSize = request.getSize();
        if (realSize == null) {
            realSize = new Dimension(0, 0);
            if (ccdTool instanceof InteractionUseCreationTool) {
                realSize.height = 50;
            } else if (ccdTool instanceof CombinedFragmentCreationTool) {
                realSize.height = 90;
            }
        }
        return realSize;
    }

    private IDiagramCommandFactory getDiagramCommandFactory(EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, List<EObject> coverage, Range creationRange) {
        DDiagramEditor diagramEditor;
        SequenceDiagram seqDiag = null;
        EditPart host = this.getHost();
        if (host instanceof SequenceDiagramEditPart) {
            seqDiag = ((SequenceDiagramEditPart)host).getSequenceDiagram();
        }
        if ((diagramEditor = (DDiagramEditor)host.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID")) == null || seqDiag == null) {
            return null;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)seqDiag.getNotationDiagram());
        Object adapter = diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        IDiagramCommandFactory diagramCommandFactory = cmdFactoryProvider.getCommandFactory(domain);
        return new SequenceDelegatingCommandFactory(diagramCommandFactory, domain, seqDiag, startingEndPredecessor, finishingEndPredecessor, coverage);
    }

    private IDiagramCommandFactory getDiagramCommandFactory(EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, Point location) {
        EditPart host = this.getHost();
        SequenceDiagram seqDiag = EditPartsHelper.getSequenceDiagram(host);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)seqDiag.getNotationDiagram());
        DDiagramEditor diagramEditor = (DDiagramEditor)this.getHost().getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        if (diagramEditor == null) {
            return null;
        }
        Object adapter = diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        IDiagramCommandFactory diagramCommandFactory = cmdFactoryProvider.getCommandFactory(domain);
        return new SequenceDelegatingCommandFactory(diagramCommandFactory, domain, seqDiag, startingEndPredecessor, finishingEndPredecessor);
    }

    private IDiagramCommandFactory getDiagramCommandFactory(EObject predecessor, Point location) {
        EditPart host = this.getHost();
        SequenceDiagram seqDiag = EditPartsHelper.getSequenceDiagram(host);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)seqDiag.getNotationDiagram());
        DDiagramEditor diagramEditor = (DDiagramEditor)this.getHost().getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        if (diagramEditor == null) {
            return null;
        }
        Object adapter = diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        IDiagramCommandFactory diagramCommandFactory = cmdFactoryProvider.getCommandFactory(domain);
        return new SequenceDelegatingCommandFactory(diagramCommandFactory, domain, seqDiag, predecessor, location);
    }
}

