/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes.emf.converter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.papyrus.infra.extendedtypes.emf.converter.ConverterNotfoundException;
import org.eclipse.papyrus.infra.extendedtypes.emf.converter.ValueSpecificationToBooleanConverter;
import org.eclipse.papyrus.infra.extendedtypes.emf.converter.ValueSpecificationToEENumConverter;
import org.eclipse.papyrus.infra.extendedtypes.emf.converter.ValueSpecificationToEnumerationConverter;
import org.eclipse.papyrus.infra.extendedtypes.emf.converter.ValueSpecificationToIntegerConverter;
import org.eclipse.papyrus.infra.extendedtypes.emf.converter.ValueSpecificationToStringConverter;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.ValueSpecification;

public class ConverterRegistry {
    private static ConverterRegistry instance;
    private Map<Class<?>, IConverter> converterMaps = new HashMap();

    private ConverterRegistry() {
    }

    public static synchronized ConverterRegistry getSingleton() {
        if (instance == null) {
            instance = new ConverterRegistry();
            instance.initializeRegistry();
        }
        return instance;
    }

    protected void initializeRegistry() {
        this.converterMaps.put(String.class, new ValueSpecificationToStringConverter());
        this.converterMaps.put(Integer.TYPE, new ValueSpecificationToIntegerConverter());
        this.converterMaps.put(Boolean.TYPE, new ValueSpecificationToBooleanConverter());
        this.converterMaps.put(Enumeration.class, new ValueSpecificationToEnumerationConverter());
        this.converterMaps.put(EEnum.class, new ValueSpecificationToEENumConverter());
    }

    public IConverter getConverter(Class<?> toType) {
        return this.converterMaps.get(toType);
    }

    public Object convert(Class<?> parameterType, ValueSpecification valueInstance) throws ConverterNotfoundException {
        IConverter converter = this.getConverter(parameterType);
        if (converter != null) {
            return converter.convert((Object)valueInstance);
        }
        throw new ConverterNotfoundException(parameterType, valueInstance);
    }
}

