/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jautodoc.JAutodocPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public final class Utils {
    public static final boolean isComment(int token) {
        return token == 1002 || token == 1003 || token == 1001;
    }

    public static final boolean isSingleLineComment(int token) {
        return token == 1001;
    }

    public static final boolean isMultiLineComment(int token) {
        return token == 1002;
    }

    public static final boolean isJavadocComment(int token) {
        return token == 1003;
    }

    public static List<String> trimStringList(List<String> list) {
        if (list.isEmpty()) {
            return list;
        }
        int startIndex = 0;
        while (startIndex < list.size() && list.get(startIndex).length() == 0) {
            ++startIndex;
        }
        int endIndex = list.size();
        while (endIndex > 0 && list.get(endIndex - 1).length() == 0) {
            --endIndex;
        }
        if (startIndex > endIndex) {
            startIndex = endIndex;
        }
        return list.subList(startIndex, endIndex);
    }

    public static boolean needsReplacement(IDocument document, IMember member, ISourceRange docRange, String replacement, boolean inherited) {
        boolean needsReplacement = true;
        try {
            if (inherited) {
                String text = document.get(member.getSourceRange().getOffset(), member.getSourceRange().getLength()).trim();
                needsReplacement = !Utils.startsWithInheritedDoc(text, replacement);
            } else if (docRange.getLength() > 0) {
                String text = document.get(docRange.getOffset(), docRange.getLength()).trim();
                needsReplacement = !text.startsWith(replacement);
            }
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException(e);
        }
        return needsReplacement;
    }

    public static boolean startsWithInheritedDoc(String text, String inheritedDoc) {
        boolean inheritDoc;
        boolean nonJavadoc = inheritedDoc.indexOf("(non-Javadoc)") != -1;
        boolean bl = inheritDoc = !nonJavadoc && inheritedDoc.indexOf("{@inheritDoc}") != -1;
        if (nonJavadoc) {
            return text.indexOf("(non-Javadoc)") != -1;
        }
        if (inheritDoc) {
            return text.indexOf("{@inheritDoc}") != -1;
        }
        String startOfText = null;
        String startOfDoc = null;
        Pattern pattern = Pattern.compile("[^/*\\s]{5,}");
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            startOfText = matcher.group();
        }
        if ((matcher = pattern.matcher(inheritedDoc)).find()) {
            startOfDoc = matcher.group();
        }
        return startOfText != null && startOfDoc != null && startOfText.equals(startOfDoc);
    }

    public static boolean needsLeadingEmptyLine(IDocument document, IMember member, ISourceRange docRange) {
        int memberOffset;
        block3: {
            try {
                memberOffset = member.getSourceRange().getOffset();
                if (memberOffset >= docRange.getOffset()) break block3;
                return false;
            }
            catch (Exception e) {
                JAutodocPlugin.getDefault().handleException(e);
                return false;
            }
        }
        int lineNumber = document.getLineOfOffset(memberOffset);
        IRegion region = document.getLineInformation(lineNumber - 1);
        String text = document.get(region.getOffset(), region.getLength()).trim();
        return text.length() > 0;
    }

    public static String getPartition(IDocument document, int offset) {
        String partition = "__dftl_partition_content_type";
        try {
            ITypedRegion region = document.getPartition(offset);
            if (region != null) {
                partition = region.getType();
            }
        }
        catch (BadLocationException badLocationException) {}
        return partition;
    }

    public static int getDocumentOffset(IDocument document, int line, int column) {
        if (line < 0 || column < 0) {
            return -1;
        }
        try {
            return document.getLineOffset(line) + column;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public static ICompilationUnit getWorkingCopy(ICompilationUnit compUnit, IEditorPart editorPart) throws JavaModelException {
        ICompilationUnit workingCopy = null;
        if (editorPart != null) {
            workingCopy = JavaUI.getWorkingCopyManager().getWorkingCopy(editorPart.getEditorInput());
        }
        if (workingCopy == null) {
            workingCopy = compUnit.isWorkingCopy() ? compUnit : compUnit.getWorkingCopy(null);
        }
        return workingCopy;
    }

    public static IEditorInput getEditorInput(IJavaElement element) throws JavaModelException {
        while (element != null) {
            ICompilationUnit unit;
            IResource resource;
            if (element instanceof ICompilationUnit && (resource = (unit = ((ICompilationUnit)element).getPrimary()).getResource()) instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            element = element.getParent();
        }
        return null;
    }

    public static IEditorPart openInEditor(IJavaElement inputElement) throws JavaModelException, PartInitException {
        FileEditorInput input = (FileEditorInput)Utils.getEditorInput(inputElement);
        if (input == null || input.getFile() == null) {
            return null;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)input.getFile(), (boolean)true);
            return editorPart;
        }
        return null;
    }

    public static IEditorPart findEditor(IJavaElement inputElement) throws JavaModelException {
        IEditorInput input = Utils.getEditorInput(inputElement);
        if (input == null) {
            return null;
        }
        IEditorPart editor = null;
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length && editor == null) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length && editor == null) {
                editor = pages[j].findEditor(input);
                ++j;
            }
            ++i;
        }
        return editor;
    }

    public static <E> Set<E> asSet(E[] array) {
        HashSet<E> set = new HashSet<E>(array.length);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            set.add(element);
            ++n2;
        }
        return set;
    }

    public static void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void close(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void close(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void close(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
    }
}

