/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.wrapper;

import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.Configuration;
import net.sf.jautodoc.preferences.ConfigurationManager;
import net.sf.jautodoc.source.CommentManager;
import net.sf.jautodoc.templates.wrapper.CharacterWrapper;
import net.sf.jautodoc.utils.StringUtils;

public class StringWrapper {
    private String string;
    private int templateKind;

    public StringWrapper() {
        this("", 0);
    }

    public StringWrapper(String string, int templateKind) {
        this.string = string != null ? string : "";
        this.templateKind = templateKind;
    }

    public StringWrapper firstToLower() {
        if (this.string.length() > 1 && Character.isUpperCase(this.string.charAt(1))) {
            return this;
        }
        return new StringWrapper(StringUtils.firstToLower(this.string), this.templateKind);
    }

    public StringWrapper firstToUpper() {
        return new StringWrapper(StringUtils.firstToUpper(this.string), this.templateKind);
    }

    public StringWrapper toUpper() {
        return new StringWrapper(this.string.toUpperCase(), this.templateKind);
    }

    public StringWrapper toLower() {
        return new StringWrapper(this.string.toLowerCase(), this.templateKind);
    }

    public StringWrapper split() {
        String comment = CommentManager.createComment(this.getConfig(), this.string, this.getScope(), true, false);
        return new StringWrapper(comment, this.templateKind);
    }

    public StringWrapper replace() {
        String comment = CommentManager.createComment(this.getConfig(), this.string, this.getScope(), false, true);
        return new StringWrapper(comment, this.templateKind);
    }

    public CharacterWrapper charAt(int index) {
        try {
            return new CharacterWrapper(this.string.charAt(index));
        }
        catch (IndexOutOfBoundsException e) {
            JAutodocPlugin.getDefault().handleException(e);
            return new CharacterWrapper(' ');
        }
    }

    public int length() {
        return this.string.length();
    }

    private int getScope() {
        if (this.templateKind == 1) {
            return 1;
        }
        if (this.templateKind == 2) {
            return 2;
        }
        if (this.templateKind == 3) {
            return 3;
        }
        if (this.templateKind == 4) {
            return 4;
        }
        if (this.templateKind == 5) {
            return 6;
        }
        return 0;
    }

    private Configuration getConfig() {
        return ConfigurationManager.getCurrentConfiguration();
    }

    public StringWrapper fl() {
        return this.firstToLower();
    }

    public StringWrapper fu() {
        return this.firstToUpper();
    }

    public StringWrapper u() {
        return this.toUpper();
    }

    public StringWrapper l() {
        return this.toLower();
    }

    public StringWrapper s() {
        return this.split();
    }

    public StringWrapper sfu() {
        String comment = CommentManager.createComment(this.getConfig(), this.string, this.getScope(), true, false, 2);
        return new StringWrapper(comment, this.templateKind);
    }

    public StringWrapper sfl() {
        String comment = CommentManager.createComment(this.getConfig(), this.string, this.getScope(), true, false, 1);
        return new StringWrapper(comment, this.templateKind);
    }

    public StringWrapper r() {
        return this.replace();
    }

    public StringWrapper rs() {
        String comment = CommentManager.createComment(this.getConfig(), this.string, this.getScope(), true, true);
        return new StringWrapper(comment, this.templateKind);
    }

    public StringWrapper rsfu() {
        String comment = CommentManager.createComment(this.getConfig(), this.string, this.getScope(), true, true, 2);
        return new StringWrapper(comment, this.templateKind);
    }

    public StringWrapper rsfl() {
        String comment = CommentManager.createComment(this.getConfig(), this.string, this.getScope(), true, true, 1);
        return new StringWrapper(comment, this.templateKind);
    }

    public String toString() {
        return this.string;
    }

    public boolean equals(Object obj) {
        return this.string.equals(obj.toString());
    }

    public int hashCode() {
        return this.string.hashCode();
    }
}

