/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.wrapper;

import net.sf.jautodoc.templates.MatchingElement;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class JavaElementWrapper {
    public static final int PROJECT = 1;
    public static final int PACKAGE = 2;
    public static final int FILE = 3;
    public static final int TYPE = 4;
    private int property;
    private IJavaElement javaElement;

    public JavaElementWrapper(MatchingElement me, int property) {
        this((IJavaElement)(me.getMember() != null ? me.getMember().getMember() : null), property);
    }

    public JavaElementWrapper(IJavaElement javaElement, int property) {
        this.property = property;
        this.javaElement = javaElement;
    }

    public String toString() {
        switch (this.property) {
            case 1: {
                return this.javaElement != null ? this.getProjectName() : "?project_name?";
            }
            case 2: {
                return this.javaElement != null ? this.getPackageName() : "?package_name?";
            }
            case 3: {
                return this.javaElement != null ? this.getFileName() : "?file_name?";
            }
            case 4: {
                return this.javaElement != null ? this.getPrimaryTypeName() : "?type_name?";
            }
        }
        return "";
    }

    private String getProjectName() {
        return this.javaElement.getJavaProject().getElementName();
    }

    private String getPackageName() {
        if (this.javaElement instanceof IPackageFragment) {
            return this.javaElement.getElementName();
        }
        ICompilationUnit compUnit = this.getCompilationUnit();
        if (compUnit == null) {
            return "";
        }
        try {
            IPackageDeclaration[] packages = compUnit.getPackageDeclarations();
            return packages.length > 0 ? packages[0].getElementName() : "";
        }
        catch (JavaModelException javaModelException) {
            return "";
        }
    }

    private String getFileName() {
        if (this.javaElement instanceof IPackageFragment) {
            return this.javaElement.getPath().lastSegment();
        }
        ICompilationUnit compUnit = this.getCompilationUnit();
        if (compUnit == null) {
            return "";
        }
        return compUnit.getElementName();
    }

    private String getPrimaryTypeName() {
        if (this.javaElement instanceof IPackageFragment) {
            return "";
        }
        ICompilationUnit compUnit = this.getCompilationUnit();
        if (compUnit == null) {
            return "";
        }
        IType type = compUnit.findPrimaryType();
        return type != null ? type.getElementName() : "";
    }

    private ICompilationUnit getCompilationUnit() {
        ICompilationUnit compUnit = null;
        if (this.javaElement instanceof ICompilationUnit) {
            compUnit = (ICompilationUnit)this.javaElement;
        } else if (this.javaElement instanceof IMember) {
            compUnit = ((IMember)this.javaElement).getCompilationUnit();
        }
        return compUnit;
    }
}

