/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.viewer;

import net.sf.jautodoc.ResourceManager;
import net.sf.jautodoc.templates.rules.SingleTokenScanner;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class TemplateViewerConfiguration
extends SourceViewerConfiguration {
    private ITextHover textHover;
    private ITokenScanner tokenScanner;
    private IAutoEditStrategy[] autoEditStrategies;
    private IContentAssistProcessor assistProcessor;

    public TemplateViewerConfiguration(ITokenScanner tokenScanner, ITextHover textHover) {
        this(tokenScanner, textHover, null, null);
    }

    public TemplateViewerConfiguration(ITokenScanner tokenScanner, ITextHover textHover, IAutoEditStrategy[] autoEditStrategies, IContentAssistProcessor assistProcessor) {
        this.textHover = textHover;
        this.tokenScanner = tokenScanner;
        this.assistProcessor = assistProcessor;
        this.autoEditStrategies = autoEditStrategies;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__singleline_comment", "__multiline_comment"};
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return this.autoEditStrategies;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.assistProcessor == null) {
            return null;
        }
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning("___template_partitioning");
        assistant.setContentAssistProcessor(this.assistProcessor, "__dftl_partition_content_type");
        assistant.enableAutoInsert(true);
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(200);
        return assistant;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if ("__dftl_partition_content_type".equals(contentType)) {
            return this.textHover;
        }
        return null;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler rec = new PresentationReconciler();
        rec.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.tokenScanner);
        rec.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        rec.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        IToken commentToken = ResourceManager.getToken("comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(commentToken));
        rec.setDamager((IPresentationDamager)dr, "__singleline_comment");
        rec.setRepairer((IPresentationRepairer)dr, "__singleline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(commentToken));
        rec.setDamager((IPresentationDamager)dr, "__multiline_comment");
        rec.setRepairer((IPresentationRepairer)dr, "__multiline_comment");
        return rec;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "___template_partitioning";
    }
}

