/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.velocity.contentassist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jautodoc.templates.contentassist.TemplateProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Point;

public class DirectiveManager {
    private static Set<String> SINGLE_LINE_DIRECTIVES = new HashSet<String>();
    private static Set<String> MULTI_LINE_DIRECTIVES = new HashSet<String>();
    private static Set<String> ALL_DIRECTIVES = new TreeSet<String>();
    private static Set<String> PARANTHESIS_DIRECTIVES = new HashSet<String>();

    static {
        SINGLE_LINE_DIRECTIVES.add("#set");
        SINGLE_LINE_DIRECTIVES.add("#stop");
        SINGLE_LINE_DIRECTIVES.add("#parse");
        SINGLE_LINE_DIRECTIVES.add("#include");
        MULTI_LINE_DIRECTIVES.add("#if");
        MULTI_LINE_DIRECTIVES.add("#macro");
        MULTI_LINE_DIRECTIVES.add("#foreach");
        ALL_DIRECTIVES.add("#end");
        ALL_DIRECTIVES.add("#else");
        ALL_DIRECTIVES.add("#elseif");
        ALL_DIRECTIVES.addAll(SINGLE_LINE_DIRECTIVES);
        ALL_DIRECTIVES.addAll(MULTI_LINE_DIRECTIVES);
        PARANTHESIS_DIRECTIVES.add("#set");
        PARANTHESIS_DIRECTIVES.add("#if");
        PARANTHESIS_DIRECTIVES.add("#elseif");
        PARANTHESIS_DIRECTIVES.add("#foreach");
        PARANTHESIS_DIRECTIVES.add("#include");
        PARANTHESIS_DIRECTIVES.add("#parse");
        PARANTHESIS_DIRECTIVES.add("#macro");
    }

    public static String[] getDirectives() {
        return ALL_DIRECTIVES.toArray(new String[ALL_DIRECTIVES.size()]);
    }

    public static boolean isMultiLineDirective(String directive) {
        return MULTI_LINE_DIRECTIVES.contains(directive);
    }

    public static boolean hasParenthesis(String directive) {
        return PARANTHESIS_DIRECTIVES.contains(directive);
    }

    public static List<ICompletionProposal> getCompletionProposals(String element, int offset, int length) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (String proposal : ALL_DIRECTIVES) {
            if (!proposal.startsWith(element)) continue;
            int cursorOffset = proposal.length();
            String displayString = proposal;
            if (DirectiveManager.hasParenthesis(proposal)) {
                proposal = String.valueOf(proposal) + "()";
                cursorOffset = proposal.length() - 1;
            }
            proposals.add(DirectiveManager.createTemplateProposal(proposal, displayString, offset, length, cursorOffset));
        }
        return proposals;
    }

    private static ICompletionProposal createTemplateProposal(String proposal, String displayString, int offset, int length, int cursorOffset) {
        return new TemplateProposal(proposal, displayString, offset, length, new Point(offset + cursorOffset, 0));
    }
}

